/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.search;

import de.jcup.asciidoctoreditor.search.AsciidocSearchResultElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class AsciidocSearchResultModel
implements AsciidocSearchResultElement {
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private ProjectElement FALLBACK_PROJECT = new ProjectElement("[NO-Project]");
    private Map<String, ProjectElement> projectElements = new TreeMap<String, ProjectElement>();

    public ResourceElement addResourceElement(IResource resource) {
        IProject project = resource.getProject();
        String projectNameToSearch = this.FALLBACK_PROJECT.getProjectName();
        if (project != null) {
            projectNameToSearch = project.getName();
        }
        ProjectElement pe = this.projectElements.computeIfAbsent(projectNameToSearch, projectName -> this.createProjectElement((String)projectName));
        ResourceElement element = new ResourceElement(resource);
        pe.resourceElements.add(element);
        return element;
    }

    private ProjectElement createProjectElement(String projectName) {
        return new ProjectElement(projectName);
    }

    @Override
    public Object[] getChildren() {
        return this.projectElements.values().toArray();
    }

    @Override
    public AsciidocSearchResultElement getParent() {
        return null;
    }

    public Object[] getFlatResourceElements() {
        ArrayList<ResourceElement.ResourceLineElement.ResourceLineContentElement> list = new ArrayList<ResourceElement.ResourceLineElement.ResourceLineContentElement>();
        for (ProjectElement pe : this.projectElements.values()) {
            for (ResourceElement element : pe.resourceElements) {
                for (ResourceElement.ResourceLineElement le : element.lines) {
                    for (ResourceElement.ResourceLineElement.ResourceLineContentElement lce : le.contentData) {
                        list.add(lce);
                    }
                }
            }
        }
        return list.toArray();
    }

    public class ProjectElement
    implements AsciidocSearchResultElement {
        private List<ResourceElement> resourceElements = new ArrayList<ResourceElement>();
        private String name;

        public ProjectElement(String name) {
            this.name = name;
        }

        public String getProjectName() {
            return this.name;
        }

        @Override
        public AsciidocSearchResultElement getParent() {
            return AsciidocSearchResultModel.this;
        }

        @Override
        public Object[] getChildren() {
            return this.resourceElements.toArray();
        }
    }

    public class ResourceElement
    implements AsciidocSearchResultElement {
        private List<ResourceLineElement> lines = new ArrayList<ResourceLineElement>();
        private IResource resource;

        public ResourceElement(IResource resource) {
            this.resource = resource;
        }

        public ResourceLineElement createNewLine(int lineNumber) {
            ResourceLineElement element = new ResourceLineElement(lineNumber);
            this.lines.add(element);
            return element;
        }

        @Override
        public Object[] getChildren() {
            return this.lines.toArray();
        }

        @Override
        public AsciidocSearchResultModel getParent() {
            return AsciidocSearchResultModel.this;
        }

        public IResource getResource() {
            return this.resource;
        }

        public class ResourceLineElement
        implements AsciidocSearchResultElement {
            private int lineNumber;
            private List<ResourceLineContentElement> contentData = new ArrayList<ResourceLineContentElement>();

            public ResourceLineElement(int lineNumber) {
                this.lineNumber = lineNumber;
            }

            public int getLineNumber() {
                return this.lineNumber;
            }

            @Override
            public ResourceElement getParent() {
                return ResourceElement.this;
            }

            public ResourceLineContentElement addContent(String text, int offset) {
                ResourceLineContentElement element = new ResourceLineContentElement(text, offset);
                this.contentData.add(element);
                return element;
            }

            @Override
            public Object[] getChildren() {
                return this.contentData.toArray();
            }

            public class ResourceLineContentElement
            implements AsciidocSearchResultElement {
                private int offset;
                private String text;

                public ResourceLineContentElement(String text, int offset) {
                    this.text = text;
                    this.offset = offset;
                }

                public String getText() {
                    return this.text;
                }

                public int getOffset() {
                    return this.offset;
                }

                @Override
                public ResourceLineElement getParent() {
                    return ResourceLineElement.this;
                }

                @Override
                public Object[] getChildren() {
                    return EMPTY_OBJ_ARRAY;
                }
            }
        }
    }
}

