/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.search;

import de.jcup.asciidoctoreditor.asciidoc.AsciiDocFileFilter;
import de.jcup.asciidoctoreditor.search.AsciidocSearchResultModel;
import de.jcup.asciidoctoreditor.ui.AsciidoctorIconConstants;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class AsciidocSearchResultLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IColorProvider,
ITableLabelProvider,
ILabelProvider {
    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public StyledString getStyledText(Object element) {
        StyledString styled = new StyledString();
        if (element instanceof AsciidocSearchResultModel.ResourceElement) {
            AsciidocSearchResultModel.ResourceElement re = (AsciidocSearchResultModel.ResourceElement)element;
            styled.append(re.getResource().getName());
        } else if (element instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement) {
            AsciidocSearchResultModel.ResourceElement.ResourceLineElement rle = (AsciidocSearchResultModel.ResourceElement.ResourceLineElement)element;
            styled.append("Line:" + rle.getLineNumber());
        } else if (element instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement) {
            AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement rle = (AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement)element;
            styled.append(rle.getText());
        } else {
            styled.append("->" + element);
        }
        return styled;
    }

    public String getText(Object element) {
        StringBuilder styled = new StringBuilder();
        if (element instanceof AsciidocSearchResultModel.ProjectElement) {
            AsciidocSearchResultModel.ProjectElement pe = (AsciidocSearchResultModel.ProjectElement)element;
            return pe.getProjectName();
        }
        if (element instanceof AsciidocSearchResultModel.ResourceElement) {
            AsciidocSearchResultModel.ResourceElement re = (AsciidocSearchResultModel.ResourceElement)element;
            IResource r = re.getResource();
            if (r == null) {
                return null;
            }
            styled.append(r.getProjectRelativePath());
        } else if (element instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement) {
            AsciidocSearchResultModel.ResourceElement.ResourceLineElement rle = (AsciidocSearchResultModel.ResourceElement.ResourceLineElement)element;
            styled.append("Line:" + rle.getLineNumber());
        } else if (element instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement) {
            AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement rle = (AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement)element;
            styled.append(rle.getText());
        } else {
            styled.append("->" + element);
        }
        return styled.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof AsciidocSearchResultModel.ProjectElement) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
        if (element instanceof AsciidocSearchResultModel.ResourceElement) {
            AsciidocSearchResultModel.ResourceElement re = (AsciidocSearchResultModel.ResourceElement)element;
            IResource resource = re.getResource();
            if (resource == null) {
                return null;
            }
            if (AsciiDocFileFilter.hasValidFileEnding(resource.getName())) {
                return EclipseUtil.getImage(AsciidoctorIconConstants.PATH_ICON_ASCIIDOCTOR_EDITOR, "de.jcup.asciidoctoreditor");
            }
            return null;
        }
        if (element instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement) {
            AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement rlce = (AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement)element;
            String text = rlce.getText();
            if (text == null) {
                return null;
            }
            if (text.startsWith("include:")) {
                return EclipseUtil.getImage(AsciidoctorIconConstants.PATH_OUTLINE_ICON_INCLUDE, "de.jcup.asciidoctoreditor");
            }
            return null;
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return this.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement) {
            AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement rlce = (AsciidocSearchResultModel.ResourceElement.ResourceLineElement.ResourceLineContentElement)element;
            AsciidocSearchResultModel.ResourceElement.ResourceLineElement le = rlce.getParent();
            if (le == null) {
                return null;
            }
            AsciidocSearchResultModel.ResourceElement re = le.getParent();
            if (re == null) {
                return null;
            }
            IResource resource = re.getResource();
            if (resource == null) {
                return null;
            }
            IProject project = resource.getProject();
            String projectName = null;
            projectName = project == null ? "(?)" : project.getName();
            StringBuilder sb = new StringBuilder();
            sb.append(projectName).append("  :  ").append(resource.getProjectRelativePath()).append(" - Line: ").append(le.getLineNumber()).append(" : ").append(rlce.getText());
            return sb.toString();
        }
        return this.getText(element);
    }
}

