/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.search;

import de.jcup.asciidoctoreditor.search.AsciidocSearchResultElement;
import de.jcup.asciidoctoreditor.search.AsciidocSearchResultModel;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class AsciidocSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private static final ImageDescriptor IMAGE_DESCRIPTOR = EclipseUtil.createImageDescriptor((String)"/icons/asciidoctor-editor.png", (String)"de.jcup.asciidoctoreditor");
    private ISearchQuery query;
    private AsciidocSearchResultModel model;

    AsciidocSearchResult(ISearchQuery query) {
        this.query = query;
        this.model = new AsciidocSearchResultModel();
    }

    public AsciidocSearchResultModel getModel() {
        return this.model;
    }

    public String getLabel() {
        return this.query.getLabel();
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return IMAGE_DESCRIPTOR;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatchesForFile(file);
    }

    private Match[] getMatchesForFile(IFile file) {
        ArrayList<Match> matches = new ArrayList<Match>();
        Object[] objectArray = this.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IFile elementFile = this.getFile(element);
            if (elementFile != null && elementFile.equals((Object)file)) {
                matches.addAll(Arrays.asList(this.getMatches(element)));
            }
            ++n2;
        }
        return matches.toArray(new Match[matches.size()]);
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof AsciidocSearchResultElement) {
            AsciidocSearchResultElement e = (AsciidocSearchResultElement)element;
            while (e != null) {
                if (e instanceof AsciidocSearchResultModel.ResourceElement) {
                    AsciidocSearchResultModel.ResourceElement re = (AsciidocSearchResultModel.ResourceElement)e;
                    IResource resource = re.getResource();
                    if (resource instanceof IFile) {
                        return (IFile)resource;
                    }
                    return null;
                }
                e = e.getParent();
            }
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFile file = this.getFile(match.getElement());
            return file != null && file.equals((Object)((IFileEditorInput)ei).getFile());
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fe = (IFileEditorInput)ei;
            return this.getMatchesForFile(fe.getFile());
        }
        return new Match[0];
    }
}

