/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.parser;

import de.jcup.asciidoctoreditor.script.AsciiDoctorFileReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SimpleReferenceParser {
    public static final SimpleReferenceParser INCLUDE_PARSER = new SimpleReferenceParser("include::", false);
    public static final SimpleReferenceParser PLANTUML_PARSER = new SimpleReferenceParser("plantuml::", false);
    public static final SimpleReferenceParser DITAA_PARSER = new SimpleReferenceParser("ditaa::", false);
    public static final SimpleReferenceParser IMAGE_PARSER = new SimpleReferenceParser("image::", true);
    protected String identifier;
    protected char firstChar;
    private boolean inline;

    public SimpleReferenceParser(String identifier, boolean inline) {
        Objects.nonNull(identifier);
        if (identifier.isEmpty()) {
            throw new IllegalArgumentException("Identifier may not be empty");
        }
        this.inline = inline;
        this.identifier = identifier;
        this.firstChar = identifier.charAt(0);
    }

    public List<AsciiDoctorFileReference> parse(String asciidoctorScript) {
        ArrayList<AsciiDoctorFileReference> list = new ArrayList<AsciiDoctorFileReference>();
        if (this.noIdentifierFound(asciidoctorScript)) {
            return list;
        }
        StringBuilder current = new StringBuilder();
        int start = 0;
        int currentPos = -1;
        char[] cArray = asciidoctorScript.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            int end;
            char c = cArray[n2];
            ++currentPos;
            if (this.inline && c == ']') {
                end = currentPos - 1;
                this.addWhenCurrentNotEmptyAndStartsWithIdentifier(asciidoctorScript, list, current, start, end);
                current = new StringBuilder();
                start = currentPos + 1;
            } else if (c == '\n') {
                end = currentPos - 1;
                this.addWhenCurrentNotEmptyAndStartsWithIdentifier(asciidoctorScript, list, current, start, end);
                current = new StringBuilder();
                start = currentPos + 1;
            } else if (!(current == null || this.inline && Character.isWhitespace(c) && !Character.isSpaceChar(c))) {
                current.append(c);
                if (current.length() == 1 && current.charAt(0) != this.firstChar) {
                    current = null;
                }
                if (current != null && current.length() == this.identifier.length() && current.indexOf(this.identifier) != 0) {
                    current = null;
                }
            }
            ++n2;
        }
        this.addWhenCurrentNotEmptyAndStartsWithIdentifier(asciidoctorScript, list, current, start, currentPos);
        return list;
    }

    private boolean noIdentifierFound(String asciidoctorScript) {
        return asciidoctorScript == null || asciidoctorScript.indexOf(this.identifier) == -1;
    }

    protected void addWhenCurrentNotEmptyAndStartsWithIdentifier(String asciidoctorScript, List<AsciiDoctorFileReference> list, StringBuilder current, int start, int end) {
        if (current == null || current.length() == 0) {
            return;
        }
        String text = current.toString().trim();
        if (!text.startsWith(this.identifier)) {
            return;
        }
        list.add(this.createInclude(asciidoctorScript, text, start, end));
    }

    private AsciiDoctorFileReference createInclude(String asciidoctorScript, String fullExpression, int start, int end) {
        AsciiDoctorFileReference include = new AsciiDoctorFileReference(fullExpression, start, end, fullExpression.length());
        return include;
    }
}

