/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.parser;

import de.jcup.asciidoctoreditor.script.AsciiDoctorInlineAnchor;
import java.util.ArrayList;
import java.util.List;

public class SimpleInlineAnchorParser {
    public List<AsciiDoctorInlineAnchor> parse(String asciidoctorScript) {
        ArrayList<AsciiDoctorInlineAnchor> list = new ArrayList<AsciiDoctorInlineAnchor>();
        if (asciidoctorScript == null || asciidoctorScript.length() < 5) {
            return list;
        }
        StringBuilder current = new StringBuilder();
        int start = 0;
        int currentPos = -1;
        char[] cArray = asciidoctorScript.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            ++currentPos;
            if (c == '\n') {
                int end = currentPos - 1;
                this.addWhenCurrentWhenValidAnchorText(asciidoctorScript, list, current, start, end);
                current = new StringBuilder();
                start = currentPos + 1;
            } else if (current != null) {
                current.append(c);
                if (current.length() == 1 && current.charAt(0) != '[') {
                    current = null;
                } else if (current.length() == 2 && current.charAt(1) != '[' && current.charAt(1) != '#') {
                    current = null;
                }
            }
            ++n2;
        }
        this.addWhenCurrentWhenValidAnchorText(asciidoctorScript, list, current, start, currentPos);
        return list;
    }

    protected void addWhenCurrentWhenValidAnchorText(String asciidoctorScript, List<AsciiDoctorInlineAnchor> list, StringBuilder current, int start, int end) {
        if (current == null || current.length() == 0) {
            return;
        }
        AsciiDoctorInlineAnchor anchor = this.createAnchor(asciidoctorScript, current.toString(), start, end);
        if (anchor == null) {
            return;
        }
        list.add(anchor);
    }

    private AsciiDoctorInlineAnchor createAnchor(String asciidoctorScript, String identifiedInclude, int start, int end) {
        String text = this.calculateAnchorText(identifiedInclude);
        if (text == null) {
            return null;
        }
        AsciiDoctorInlineAnchor anchor = new AsciiDoctorInlineAnchor(text, start, end);
        return anchor;
    }

    private String calculateAnchorText(String identified) {
        if (identified == null) {
            return null;
        }
        String anchor = identified.trim();
        if (anchor.startsWith("[[") && anchor.endsWith("]]")) {
            return anchor;
        }
        if (anchor.startsWith("[#") && anchor.endsWith("]")) {
            return anchor;
        }
        return null;
    }
}

