/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.parser;

import de.jcup.asciidoctoreditor.script.AsciiDoctorHeadline;
import java.util.ArrayList;
import java.util.List;

public class SimpleHeadlineParser {
    public List<AsciiDoctorHeadline> parse(String asciidoctorScript) {
        ArrayList<AsciiDoctorHeadline> list = new ArrayList<AsciiDoctorHeadline>();
        if (asciidoctorScript == null) {
            return list;
        }
        StringBuilder current = new StringBuilder();
        int start = 0;
        int currentPos = -1;
        char[] cArray = asciidoctorScript.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            ++currentPos;
            if (c == '\n') {
                int end = currentPos - 1;
                this.addHeadlineWhenCurrentNotEmptyAndHasASpaceAfterLastEqual(asciidoctorScript, list, current, start, end);
                current = new StringBuilder();
                start = currentPos + 1;
            } else if (current != null) {
                current.append(c);
                if (current.charAt(0) != '=') {
                    current = null;
                }
            }
            ++n2;
        }
        this.addHeadlineWhenCurrentNotEmptyAndHasASpaceAfterLastEqual(asciidoctorScript, list, current, start, currentPos);
        return list;
    }

    protected void addHeadlineWhenCurrentNotEmptyAndHasASpaceAfterLastEqual(String asciidoctorScript, List<AsciiDoctorHeadline> list, StringBuilder current, int start, int end) {
        AsciiDoctorHeadline headline;
        if (current != null && current.length() > 0 && (headline = this.createHeadlineOrNull(asciidoctorScript, current.toString(), start, end)) != null) {
            list.add(headline);
        }
    }

    private AsciiDoctorHeadline createHeadlineOrNull(String asciidoctorScript, String identifiedHeadline, int start, int end) {
        boolean charAfterEqualWasSpace = false;
        char[] cArray = identifiedHeadline.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c != '=') {
                charAfterEqualWasSpace = c == ' ';
                break;
            }
            ++n2;
        }
        if (!charAfterEqualWasSpace) {
            return null;
        }
        String name = this.calculateName(identifiedHeadline);
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        int deep = this.calculateDeep(identifiedHeadline);
        AsciiDoctorHeadline headline = new AsciiDoctorHeadline(deep, name, start, end, identifiedHeadline.length());
        return headline;
    }

    private String calculateName(String identifiedHeadline) {
        if (identifiedHeadline == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = identifiedHeadline.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char charAt = cArray[n2];
            if (sb.length() != 0 || charAt != '=') {
                sb.append(charAt);
            }
            ++n2;
        }
        return sb.toString().trim();
    }

    private int calculateDeep(String word) {
        if (word == null) {
            return 0;
        }
        int deep = 0;
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char charAt = cArray[n2];
            if (charAt != '=') break;
            ++deep;
            ++n2;
        }
        return deep;
    }
}

