/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.parser;

public class ParseToken {
    private static final String EQUAL_OPERAND = "=";
    String text;
    int start;
    int end;

    ParseToken() {
    }

    ParseToken(String text) {
        this(text, 0, 0);
    }

    ParseToken(String text, int start, int end) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        this.start = start;
        this.end = end;
    }

    public String getText() {
        return this.text;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createTypeDescription());
        sb.append(":'");
        sb.append(this.text);
        sb.append('\'');
        return sb.toString();
    }

    public String createTypeDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.isComment()) {
            sb.append("PLANTUML_NOTE");
        }
        if (this.isVariable()) {
            sb.append("VARIABLE");
        }
        if (this.isString()) {
            sb.append("STRING");
        }
        if (this.isIf()) {
            sb.append("IF");
        }
        if (this.isFi()) {
            sb.append("FI");
        }
        if (this.isCase()) {
            sb.append("CASE");
        }
        if (this.isEsac()) {
            sb.append("ESAC");
        }
        if (this.isDo()) {
            sb.append("DO");
        }
        if (this.isDone()) {
            sb.append("DONE");
        }
        if (this.isCloseBlock()) {
            sb.append("BLOCK-CLOSE");
        }
        if (this.isOpenBlock()) {
            sb.append("BLOCK-OPEN");
        }
        if (sb.length() == 0) {
            sb.append("EXPRESSION");
        }
        return sb.toString();
    }

    private boolean isVariable() {
        return this.getSafeText().startsWith("$");
    }

    public boolean isComment() {
        return this.getSafeText().startsWith("#");
    }

    public boolean isSingleString() {
        return this.getSafeText().startsWith("'");
    }

    public boolean isDoubleString() {
        return this.getSafeText().startsWith("\"");
    }

    public boolean isDoubleTickedString() {
        return this.getSafeText().startsWith("`");
    }

    private String getSafeText() {
        return this.text == null ? "" : this.text;
    }

    public boolean isString() {
        boolean isString = this.isSingleString() || this.isDoubleString() || this.isDoubleTickedString();
        return isString;
    }

    public boolean isFunctionKeyword() {
        return "function".equals(this.text);
    }

    public boolean isFunction() {
        boolean isFunctionName = this.endsWithFunctionBrackets();
        isFunctionName = isFunctionName && this.isLegalFunctionName();
        isFunctionName = isFunctionName && !this.isComment();
        isFunctionName = isFunctionName && this.text.length() > 2;
        isFunctionName = isFunctionName && !this.isString();
        return isFunctionName;
    }

    public boolean isLegalFunctionName() {
        return !this.getSafeText().contains(EQUAL_OPERAND);
    }

    public boolean endsWithFunctionBrackets() {
        return this.getSafeText().endsWith("()");
    }

    public boolean hasLength(int length) {
        return this.getSafeText().length() == length;
    }

    public String getTextAsFunctionName() {
        if (this.getSafeText().endsWith("()")) {
            return this.text.substring(0, this.text.length() - 2);
        }
        return this.text;
    }

    public boolean isOpenBlock() {
        return this.getSafeText().length() == 1 && this.text.endsWith("{");
    }

    public boolean isCloseBlock() {
        return this.getSafeText().length() == 1 && this.text.endsWith("}");
    }

    public boolean isDo() {
        return this.getSafeText().equals("do");
    }

    public boolean isDone() {
        return this.getSafeText().equals("done");
    }

    public boolean isIf() {
        return this.getSafeText().equals("if");
    }

    public boolean isFi() {
        return this.getSafeText().equals("fi");
    }

    public boolean isHereDoc() {
        return !this.isHereString() && this.getSafeText().startsWith("<<");
    }

    public boolean isHereString() {
        return this.getSafeText().startsWith("<<<");
    }

    public boolean isCase() {
        return this.getSafeText().equals("case");
    }

    public boolean isEsac() {
        return this.getSafeText().equals("esac");
    }
}

