/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.parser;

import de.jcup.asciidoctoreditor.script.parser.CodePosSupport;
import de.jcup.asciidoctoreditor.script.parser.ParseToken;
import de.jcup.asciidoctoreditor.script.parser.ParserState;
import de.jcup.asciidoctoreditor.script.parser.VariableState;
import java.util.ArrayList;
import java.util.List;

class ParseContext
implements CodePosSupport {
    char[] chars;
    int pos;
    StringBuilder sb;
    List<ParseToken> tokens = new ArrayList<ParseToken>();
    ParseToken currentToken;
    private ParserState parserState = ParserState.INIT;
    private ParserState stateBeforeString;
    private VariableContext variableContext;

    ParseContext() {
        this.currentToken = this.createToken();
    }

    void addTokenAndResetText() {
        if (this.moveCurrentTokenPosWhenEmptyText()) {
            return;
        }
        this.currentToken.text = this.sb.toString();
        this.currentToken.end = this.pos;
        this.tokens.add(this.currentToken);
        this.currentToken = this.createToken();
        this.currentToken.start = this.pos + 1;
        this.resetText();
    }

    void addToken(ParseToken token) {
        this.tokens.add(token);
    }

    void appendCharToText() {
        this.getSb().append(this.getCharAtPos());
    }

    char getCharAtPos() {
        return this.chars[this.pos];
    }

    @Override
    public int getInitialStartPos() {
        return this.pos;
    }

    char getCharBefore() {
        Character c = this.getCharacterAtPosOrNull(this.pos - 1);
        if (c == null) {
            return '\u0000';
        }
        return c.charValue();
    }

    @Override
    public Character getCharacterAtPosOrNull(int wantedPos) {
        int length;
        if (wantedPos >= 0 && (length = this.chars.length) > wantedPos) {
            return Character.valueOf(this.chars[wantedPos]);
        }
        return null;
    }

    boolean insideString() {
        boolean inString = false;
        inString = inString || this.inState(ParserState.INSIDE_DOUBLE_STRING);
        inString = inString || this.inState(ParserState.INSIDE_DOUBLE_TICKED);
        inString = inString || this.inState(ParserState.INSIDE_SINGLE_STRING);
        return inString;
    }

    boolean inState(ParserState parserState) {
        return this.getState().equals((Object)parserState);
    }

    boolean moveCurrentTokenPosWhenEmptyText() {
        if (this.getSb().length() == 0) {
            ++this.currentToken.start;
            return true;
        }
        return false;
    }

    void restoreStateBeforeString() {
        this.switchTo(this.stateBeforeString);
    }

    void switchTo(ParserState parserState) {
        this.parserState = parserState;
        if (ParserState.VARIABLE.equals((Object)parserState)) {
            this.getVariableContext().variableState = VariableState.NO_ARRAY;
            this.getVariableContext().setType(VariableType.INITIAL);
        } else {
            this.variableContext = null;
        }
    }

    void switchToStringState(ParserState newStringState) {
        this.stateBeforeString = this.getState();
        this.switchTo(newStringState);
    }

    private ParseToken createToken() {
        ParseToken token = new ParseToken();
        token.start = this.pos;
        return token;
    }

    private StringBuilder getSb() {
        if (this.sb == null) {
            this.sb = new StringBuilder();
        }
        return this.sb;
    }

    private ParserState getState() {
        if (this.parserState == null) {
            this.parserState = ParserState.UNKNOWN;
        }
        return this.parserState;
    }

    private void resetText() {
        this.sb = null;
    }

    public VariableContext getVariableContext() {
        if (this.variableContext == null) {
            this.variableContext = new VariableContext();
        }
        return this.variableContext;
    }

    public String toString() {
        return "ParseContext:" + this.getSb().toString() + "\nTokens:" + this.tokens;
    }

    public boolean hasValidPos() {
        return this.pos < this.chars.length;
    }

    public void moveForward() {
        ++this.pos;
    }

    public boolean canMoveForward() {
        return this.pos < this.chars.length - 1;
    }

    public boolean isCharBeforeEscapeSign() {
        return this.getCharBefore() == '\\';
    }

    public void moveBackWard() {
        --this.pos;
    }

    @Override
    public void moveToPos(int pos) {
        this.pos = pos;
    }

    public class VariableContext {
        private VariableState variableState = VariableState.NO_ARRAY;
        private VariableType type;
        private int variableOpenCurlyBraces;
        private int variableCloseCurlyBraces;
        private int variableGroupOpen;
        private int variableGroupClosed;

        public void incrementVariableOpenCurlyBraces() {
            ++this.variableOpenCurlyBraces;
        }

        public VariableType getType() {
            return this.type;
        }

        public void setType(VariableType type) {
            this.type = type;
        }

        public void incrementVariableCloseCurlyBraces() {
            ++this.variableCloseCurlyBraces;
        }

        public boolean areVariableCurlyBracesBalanced() {
            return this.variableOpenCurlyBraces == this.variableCloseCurlyBraces;
        }

        public void variableArrayOpened() {
            this.variableState = VariableState.ARRAY_OPENED;
        }

        public void variableArrayClosed() {
            this.variableState = VariableState.ARRAY_CLOSED;
        }

        public boolean isInsideVariableArray() {
            boolean isInside = ParseContext.this.inState(ParserState.VARIABLE);
            isInside = isInside && VariableState.ARRAY_OPENED.equals((Object)this.variableState);
            return isInside;
        }

        public void variableGroupOpened() {
            ++this.variableGroupOpen;
        }

        public void variableGroupClosed() {
            ++this.variableGroupClosed;
        }

        public boolean areVariableGroupsBalanced() {
            return this.variableGroupOpen == this.variableGroupClosed;
        }

        public boolean hasNoOpenedCurlyBraces() {
            return this.variableOpenCurlyBraces == 0;
        }
    }

    public static enum VariableType {
        INITIAL,
        STANDARD,
        GROUPED,
        CURLY_BRACED;

    }
}

