/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.formatter;

import de.jcup.asciidoctoreditor.script.formatter.AsciidocBlockScanMethods;
import java.util.function.Function;

public enum AsciidocBlockType {
    EMPTY_LINE(AsciidocBlockScanMethods::isNewLine, false),
    TABLE(AsciidocBlockScanMethods::isTableMarker, true),
    HEADLINE(AsciidocBlockScanMethods::isHeadlineMarker, false),
    SIMPLE_COMMENT(AsciidocBlockScanMethods::isSingleLineComment, false),
    BLOCK(AsciidocBlockScanMethods::isBlockMarker, true),
    COMMAND(AsciidocBlockScanMethods::isCommandMarker, false),
    META_INFO(AsciidocBlockScanMethods::isMetaInfoMarker, false),
    VARIABLE(AsciidocBlockScanMethods::isVariableMarker, false),
    TEXT(AsciidocBlockScanMethods::isTextOnly, true),
    UNKNOWN(null, false);

    private Function<String, Boolean> function;
    private boolean multipleLines;

    private AsciidocBlockType(Function<String, Boolean> function, boolean multipleLines) {
        this.function = function;
        this.multipleLines = multipleLines;
    }

    public boolean isMultipleLines() {
        return this.multipleLines;
    }

    public boolean isIdentifiedBy(String line) {
        if (this.function == null) {
            return false;
        }
        Boolean r = this.function.apply(line);
        if (r == null) {
            return false;
        }
        return r;
    }

    public static AsciidocBlockType determineType(String line) {
        AsciidocBlockType[] asciidocBlockTypeArray = AsciidocBlockType.values();
        int n = asciidocBlockTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsciidocBlockType type = asciidocBlockTypeArray[n2];
            if (type.isIdentifiedBy(line)) {
                return type;
            }
            ++n2;
        }
        return null;
    }
}

