/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.formatter;

import de.jcup.asciidoctoreditor.script.formatter.AsciidocBlockType;
import de.jcup.asciidoctoreditor.script.formatter.AsciidocFormatBlock;
import java.util.ArrayList;
import java.util.List;

public class AsciidocBlockScanner {
    public List<AsciidocFormatBlock> scan(String source) {
        Context context = new Context();
        StringBuilder sb = new StringBuilder();
        char[] cArray = source.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n') {
                context.addLine(sb.toString(), true);
                sb = new StringBuilder();
            } else {
                sb.append(c);
            }
            ++n2;
        }
        if (sb.length() > 0) {
            context.addLine(sb.toString(), false);
        }
        context.closeBlock();
        return context.asciidocFormatBlocks;
    }

    private class Context {
        List<AsciidocFormatBlock> asciidocFormatBlocks = new ArrayList<AsciidocFormatBlock>();
        StringBuilder current = new StringBuilder();
        private AsciidocFormatBlock asciidocFormatBlock;

        private Context() {
        }

        public void addLine(String line, boolean appendNewLine) {
            AsciidocBlockType type = AsciidocBlockType.determineType(line);
            this.current.append(line);
            if (appendNewLine) {
                this.current.append("\n");
            }
            if (type.isMultipleLines()) {
                if (this.asciidocFormatBlock == null || this.asciidocFormatBlock.blockType == null) {
                    this.closeOldBlockAndStartBlock(type);
                    return;
                }
                if (type == this.asciidocFormatBlock.blockType) {
                    this.closeOldBlock();
                    return;
                }
                return;
            }
            this.closeOldBlockAndStartSingleLine(type);
        }

        private void closeOldBlock() {
            if (this.asciidocFormatBlock != null) {
                this.asciidocFormatBlock.source.append(this.current.toString());
                this.asciidocFormatBlocks.add(this.asciidocFormatBlock);
            }
            this.current = new StringBuilder();
            this.asciidocFormatBlock = null;
        }

        private void closeOldBlockAndStartSingleLine(AsciidocBlockType type) {
            if (this.asciidocFormatBlock != null) {
                this.asciidocFormatBlocks.add(this.asciidocFormatBlock);
            }
            this.asciidocFormatBlock = new AsciidocFormatBlock();
            this.asciidocFormatBlock.blockType = type;
            this.asciidocFormatBlock.source.append(this.current.toString());
            this.asciidocFormatBlocks.add(this.asciidocFormatBlock);
            this.current = new StringBuilder();
            this.asciidocFormatBlock = null;
        }

        private void closeOldBlockAndStartBlock(AsciidocBlockType type) {
            if (this.asciidocFormatBlock != null) {
                this.asciidocFormatBlock.source.append(this.current.toString());
                this.asciidocFormatBlocks.add(this.asciidocFormatBlock);
                this.current = new StringBuilder();
            }
            this.asciidocFormatBlock = new AsciidocFormatBlock();
            this.asciidocFormatBlock.blockType = type;
        }

        public void closeBlock() {
            if (this.asciidocFormatBlock != null) {
                this.asciidocFormatBlock.source.append(this.current.toString());
                this.asciidocFormatBlocks.add(this.asciidocFormatBlock);
                this.current = new StringBuilder();
            }
        }
    }
}

