/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.formatter;

public class AsciidocBlockScanMethods {
    public static Boolean isNewLine(String line) {
        if (!line.isEmpty() && !line.startsWith("\n")) {
            return false;
        }
        return true;
    }

    public static Boolean isBlockMarker(String line) {
        return line.startsWith("----");
    }

    public static Boolean isMetaInfoMarker(String line) {
        return line.startsWith("[");
    }

    public static Boolean isTableMarker(String line) {
        return line.startsWith("|==");
    }

    public static Boolean isSingleLineComment(String line) {
        return line.trim().startsWith("//");
    }

    public static Boolean isHeadlineMarker(String line) {
        if (line.indexOf("= ") != -1) {
            return true;
        }
        return false;
    }

    public static Boolean isVariableMarker(String line) {
        return line.startsWith(":");
    }

    public static Boolean isCommandMarker(String line) {
        if (line.indexOf("::") == -1) {
            return false;
        }
        int before = 97;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            int c = cArray[n2];
            if (c == 32 || c == 34 || c == 39) {
                return false;
            }
            if (c == 58 && before == 58) {
                return true;
            }
            before = c;
            ++n2;
        }
        return false;
    }

    public static Boolean isTextOnly(String line) {
        boolean textOnly = true;
        textOnly = textOnly && AsciidocBlockScanMethods.isNewLine(line) == false;
        textOnly = textOnly && AsciidocBlockScanMethods.isTableMarker(line) == false;
        textOnly = textOnly && AsciidocBlockScanMethods.isBlockMarker(line) == false;
        textOnly = textOnly && AsciidocBlockScanMethods.isHeadlineMarker(line) == false;
        textOnly = textOnly && AsciidocBlockScanMethods.isHeadlineMarker(line) == false;
        textOnly = textOnly && AsciidocBlockScanMethods.isVariableMarker(line) == false;
        textOnly = textOnly && AsciidocBlockScanMethods.isCommandMarker(line) == false;
        return textOnly;
    }
}

