/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.formatter;

import de.jcup.asciidoctoreditor.script.formatter.AsciiDoctorFormatterConfig;

public class AsciiDoctorSimpleTextFormatter {
    public String format(String origin, AsciiDoctorFormatterConfig config) {
        if (origin == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        State state = State.INIT;
        StringBuilder current = new StringBuilder();
        char[] array = origin.toCharArray();
        int max = array.length;
        int i = 0;
        while (i < max) {
            char c = array[i];
            if (state == State.NEWLINE) {
                sb.append((CharSequence)current);
                current = new StringBuilder();
                state = State.INIT;
            }
            current.append(c);
            if (c == '\n') {
                state = State.NEWLINE;
            } else if (state != State.LINE_COMMENT) {
                String string = current.toString();
                if (string.trim().startsWith("//")) {
                    state = State.LINE_COMMENT;
                } else if (string.length() == config.maxColumn) {
                    boolean nextCharIsWhitespace;
                    int next = i + 1;
                    boolean charIsWhitespace = Character.isWhitespace(c);
                    boolean bl = nextCharIsWhitespace = charIsWhitespace || next <= max && Character.isWhitespace(array[next]);
                    if (nextCharIsWhitespace) {
                        current.append("\n");
                        state = State.NEWLINE;
                    } else {
                        String allowedText = "";
                        int m = string.length() - 1;
                        while (m > 0) {
                            char charAt = string.charAt(m);
                            if (Character.isWhitespace(charAt)) {
                                if (string.length() > m + 1) {
                                    allowedText = string.substring(0, m + 1);
                                    break;
                                }
                                allowedText = string.substring(0, m);
                                break;
                            }
                            --m;
                        }
                        sb.append(allowedText);
                        sb.append("\n");
                        current = new StringBuilder();
                        String newOne = string.substring(allowedText.length());
                        current.append(newOne);
                        state = State.SIMPLE_TEXT;
                    }
                }
            }
            ++i;
        }
        if (current.length() > 0) {
            sb.append((CharSequence)current);
        }
        return sb.toString().trim();
    }

    private static enum State {
        INIT,
        NEWLINE,
        SIMPLE_TEXT,
        LINE_COMMENT,
        MULTI_LINE_COMMENT,
        BLOCK,
        HEADLINE;

    }
}

