/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script.formatter;

import de.jcup.asciidoctoreditor.script.formatter.AsciiDoctorFormatterConfig;
import de.jcup.asciidoctoreditor.script.formatter.AsciiDoctorSimpleTextFormatter;
import de.jcup.asciidoctoreditor.script.formatter.AsciidocBlockScanner;
import de.jcup.asciidoctoreditor.script.formatter.AsciidocBlockType;
import de.jcup.asciidoctoreditor.script.formatter.AsciidocFormatBlock;
import java.util.List;

public class AsciiDoctorFormatter {
    private AsciidocBlockScanner blockScanner = new AsciidocBlockScanner();
    private AsciiDoctorSimpleTextFormatter simpleTextFormatter = new AsciiDoctorSimpleTextFormatter();

    public String format(String origin, AsciiDoctorFormatterConfig config) {
        if (origin == null) {
            return "";
        }
        List<AsciidocFormatBlock> blocks = this.blockScanner.scan(origin);
        StringBuilder sb = new StringBuilder();
        for (AsciidocFormatBlock block : blocks) {
            this.handleBlock(block, config);
            sb.append((CharSequence)block.source);
        }
        return sb.toString();
    }

    private void handleBlock(AsciidocFormatBlock block, AsciiDoctorFormatterConfig config) {
        if (block.blockType == AsciidocBlockType.TEXT) {
            block.source = new StringBuilder().append(this.simpleTextFormatter.format(block.source.toString(), config));
        }
    }
}

