/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script;

import de.jcup.asciidoctoreditor.script.AsciiDoctorFileReference;
import de.jcup.asciidoctoreditor.script.AsciiDoctorHeadline;
import de.jcup.asciidoctoreditor.script.AsciiDoctorInlineAnchor;
import de.jcup.asciidoctoreditor.script.AsciiDoctorScriptModel;
import de.jcup.asciidoctoreditor.script.AsciiDoctorScriptModelException;
import de.jcup.asciidoctoreditor.script.parser.SimpleHeadlineParser;
import de.jcup.asciidoctoreditor.script.parser.SimpleInlineAnchorParser;
import de.jcup.asciidoctoreditor.script.parser.SimpleReferenceParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class AsciiDoctorScriptModelBuilder {
    private SimpleHeadlineParser headlineParser = new SimpleHeadlineParser();
    private SimpleInlineAnchorParser inlineAnchorParser = new SimpleInlineAnchorParser();

    public AsciiDoctorScriptModel build(String asciidoctorScript) throws AsciiDoctorScriptModelException {
        AsciiDoctorScriptModel model = new AsciiDoctorScriptModel();
        List<AsciiDoctorHeadline> headlines = this.headlineParser.parse(asciidoctorScript);
        List<AsciiDoctorFileReference> includes = SimpleReferenceParser.INCLUDE_PARSER.parse(asciidoctorScript);
        List<AsciiDoctorFileReference> images = SimpleReferenceParser.IMAGE_PARSER.parse(asciidoctorScript);
        List<AsciiDoctorFileReference> plantuml = SimpleReferenceParser.PLANTUML_PARSER.parse(asciidoctorScript);
        List<AsciiDoctorFileReference> ditaa = SimpleReferenceParser.DITAA_PARSER.parse(asciidoctorScript);
        List<AsciiDoctorInlineAnchor> inlineAnchors = this.inlineAnchorParser.parse(asciidoctorScript);
        model.getHeadlines().addAll(headlines);
        model.getIncludes().addAll(includes);
        model.getInlineAnchors().addAll(inlineAnchors);
        model.getImages().addAll(images);
        model.getDiagrams().addAll(plantuml);
        model.getDiagrams().addAll(ditaa);
        this.handleHeadlinesWithAnchorsBefore(model);
        this.handleHeadlinesWithSameCalculatedIdsWhereNoIdSet(model);
        return model;
    }

    private void handleHeadlinesWithAnchorsBefore(AsciiDoctorScriptModel model) {
        block0: for (AsciiDoctorHeadline headline : model.getHeadlines()) {
            int headlinePosition = headline.getPosition();
            for (AsciiDoctorInlineAnchor anchor : model.getInlineAnchors()) {
                int anchorEnd = anchor.getEnd();
                if (anchorEnd + 2 != headlinePosition) continue;
                headline.setId(anchor.getId());
                continue block0;
            }
        }
    }

    private void handleHeadlinesWithSameCalculatedIdsWhereNoIdSet(AsciiDoctorScriptModel model) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        HashSet<String> firstTagged = new HashSet<String>();
        for (AsciiDoctorHeadline headline : model.getHeadlines()) {
            String calculatedId = headline.getCalculatedId();
            if (calculatedId == null) continue;
            Integer count = map.compute(calculatedId, (k, v) -> v == null ? 1 : v + 1);
            if (headline.isIdSet()) continue;
            if (firstTagged.contains(calculatedId)) {
                headline.setId(String.valueOf(calculatedId) + "_" + count);
                continue;
            }
            headline.setId(calculatedId);
            firstTagged.add(calculatedId);
        }
    }

    protected int getIndexWhereGraphvizBecomesNecessary(String asciidoctorScript) {
        int index = asciidoctorScript.indexOf("[plantuml");
        if (index == -1) {
            index = asciidoctorScript.indexOf("[graphviz");
        }
        return index;
    }
}

