/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script;

import de.jcup.asciidoctoreditor.script.AsciidoctorTextSelectable;

public class AsciiDoctorInlineAnchor
implements AsciidoctorTextSelectable {
    private int end;
    private int position;
    private String label;
    private String id;
    private int selectionLength;

    public AsciiDoctorInlineAnchor(String text, int position, int end) {
        if (text == null) {
            text = "";
        }
        this.label = text;
        this.end = end;
        this.position = position;
        this.id = this.createIDByLabel();
        this.selectionLength = this.id.length();
    }

    private String createIDByLabel() {
        String id = this.createIDByLabelNoCommataCheck();
        if (id == null) {
            return null;
        }
        int index = id.indexOf(44);
        if (index != -1) {
            id = id.substring(0, index);
        }
        return id.trim();
    }

    private String createIDByLabelNoCommataCheck() {
        if (this.label == null) {
            return null;
        }
        if (this.label.startsWith("[[")) {
            if (!this.label.endsWith("]]")) {
                return "illegal-noend-" + System.nanoTime();
            }
            return this.label.substring(2, this.label.length() - 2);
        }
        if (this.label.startsWith("[#")) {
            if (this.label.endsWith("]]")) {
                return "illegal-noend-" + System.nanoTime();
            }
            if (!this.label.endsWith("]")) {
                return "illegal-noend-" + System.nanoTime();
            }
            return this.label.substring(2, this.label.length() - 1);
        }
        return "illegal-nostart-" + System.nanoTime();
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public int getEnd() {
        return this.end;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int getSelectionStart() {
        return this.getPosition() + 2;
    }

    @Override
    public int getSelectionLength() {
        return this.selectionLength;
    }
}

