/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script;

import de.jcup.asciidoctoreditor.script.AsciidoctorTextSelectable;
import java.util.regex.Pattern;

public class AsciiDoctorHeadline
implements AsciidoctorTextSelectable {
    private static final String REGEXP_STRING = "\\W";
    private static final Pattern REGEXP = Pattern.compile("\\W", 256);
    String name;
    int position;
    int lengthToNameEnd;
    int end;
    int deep;
    private String calculatedId;
    private String id;

    public AsciiDoctorHeadline(int deep, String name, int position, int end, int lengthTonNameEnd) {
        this.deep = deep;
        this.name = name;
        this.position = position;
        this.end = end;
        this.lengthToNameEnd = lengthTonNameEnd;
        this.calculatedId = AsciiDoctorHeadline.calculateId(name);
    }

    void setId(String id) {
        this.id = id;
    }

    boolean isIdSet() {
        return this.id != null;
    }

    public String getCalculatedId() {
        return this.calculatedId;
    }

    static String calculateId(String name) {
        if (name == null) {
            return "";
        }
        String id = REGEXP.matcher(name).replaceAll("_");
        id = "_" + id.toLowerCase();
        while (id.length() > 1 && id.endsWith("_")) {
            id = id.substring(0, id.length() - 1);
        }
        while (id.indexOf("__") != -1) {
            id = id.replaceAll("__", "_");
        }
        return id;
    }

    public int getLengthToNameEnd() {
        return this.lengthToNameEnd;
    }

    @Override
    public int getSelectionStart() {
        return this.getPosition();
    }

    @Override
    public int getSelectionLength() {
        return this.getLengthToNameEnd();
    }

    public int getDeep() {
        return this.deep;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public int getEnd() {
        return this.end;
    }

    public String getId() {
        if (this.id == null) {
            return this.calculatedId;
        }
        return this.id;
    }

    public String toString() {
        return "h" + this.deep + ":" + this.name + "[pos:" + this.position + ",end:" + this.end + ",lengthToNameEnd:" + this.lengthToNameEnd + "]";
    }
}

