/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script;

import de.jcup.asciidoctoreditor.script.AsciiDoctorFileReference;
import de.jcup.asciidoctoreditor.script.AsciiDoctorMarker;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;

public class AsciiDoctorFileReferenceValidator {
    private boolean urlTestingEnabled;

    public AsciiDoctorFileReferenceValidator(boolean urlTestingEnabled) {
        this.urlTestingEnabled = urlTestingEnabled;
    }

    public void validate(File referenceBaseFileOrFolder, Collection<AsciiDoctorFileReference> references, Collection<AsciiDoctorMarker> errors) {
        if (errors == null) {
            return;
        }
        if (referenceBaseFileOrFolder == null) {
            return;
        }
        if (!referenceBaseFileOrFolder.exists()) {
            return;
        }
        File referenceBaseDirectory = referenceBaseFileOrFolder;
        if (!referenceBaseDirectory.isDirectory()) {
            referenceBaseDirectory = referenceBaseDirectory.getParentFile();
        }
        for (AsciiDoctorFileReference reference : references) {
            String problem;
            block16: {
                problem = null;
                String filePathAsString = reference.getFilePath();
                if (filePathAsString == null) continue;
                if (filePathAsString.indexOf("://") != -1) {
                    try {
                        URL url = new URL(filePathAsString);
                        if (!this.urlTestingEnabled) break block16;
                        URLConnection conn = url.openConnection();
                        if (conn instanceof HttpURLConnection) {
                            HttpURLConnection huc = (HttpURLConnection)conn;
                            int responseCode = huc.getResponseCode();
                            if (responseCode < 200 || responseCode > 299) {
                                problem = ".. returned HTTP code " + responseCode + " for given URL:" + filePathAsString;
                            }
                            break block16;
                        }
                        conn.connect();
                    }
                    catch (MalformedURLException e) {
                        problem = ".. given URL was malformed:" + filePathAsString + " - " + e.getMessage();
                    }
                    catch (UnknownHostException unknownHostException) {
                        problem = ".. was not able to find host for given URL:" + filePathAsString;
                    }
                    catch (IOException iOException) {
                        problem = ".. was not able to connect to given URL:" + filePathAsString;
                    }
                } else {
                    Path filePath;
                    Path referenceBaseDirPath = referenceBaseDirectory.toPath();
                    File expectedFile = referenceBaseDirPath.resolve(filePath = Paths.get(filePathAsString, new String[0])).toFile();
                    if (!expectedFile.exists()) {
                        problem = ".. references not existing file:" + expectedFile.getAbsolutePath();
                    } else if (expectedFile.isDirectory()) {
                        problem = ".. points to a directory not a file:" + expectedFile.getAbsolutePath();
                    }
                }
            }
            if (problem == null) continue;
            AsciiDoctorMarker marker = new AsciiDoctorMarker(reference.getPosition(), reference.getEnd(), "Validation failed:" + reference.getTargetPrefix() + problem);
            errors.add(marker);
        }
    }
}

