/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.script;

public class AsciiDoctorFileReference {
    String target;
    int position;
    int lengthToNameEnd;
    public int end;
    private String targetPrefix;
    private String fullExpression;
    private String filePath;

    public AsciiDoctorFileReference(String fullExpression, int position, int end, int lengthTonNameEnd) {
        this.fullExpression = fullExpression;
        this.target = this.calculateTarget(fullExpression);
        this.position = position;
        this.end = end;
        this.lengthToNameEnd = lengthTonNameEnd;
        this.targetPrefix = this.resolveTargetPrefix();
        this.filePath = this.resolveFilePath();
    }

    private String calculateTarget(String fullExpression) {
        if (fullExpression == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = fullExpression.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char charAt = cArray[n2];
            if (!this.isPartOfTarget(charAt)) break;
            sb.append(charAt);
            ++n2;
        }
        return sb.toString().trim();
    }

    private boolean isPartOfTarget(char charAt) {
        if (Character.isSpaceChar(charAt)) {
            return true;
        }
        if (charAt == '[') {
            return false;
        }
        return !Character.isWhitespace(charAt);
    }

    private String resolveTargetPrefix() {
        if (this.target == null) {
            return "";
        }
        int prefixIndex = this.target.indexOf("::");
        if (prefixIndex == -1) {
            return "";
        }
        return this.target.substring(0, prefixIndex + 2);
    }

    private String resolveFilePath() {
        if (this.target == null) {
            return "null";
        }
        if (this.targetPrefix == null || this.targetPrefix.isEmpty()) {
            return this.target;
        }
        String filePath = this.target;
        if (filePath.startsWith(this.targetPrefix)) {
            filePath = filePath.substring(this.targetPrefix.length());
        }
        return filePath;
    }

    public int getLengthToNameEnd() {
        return this.lengthToNameEnd;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargetPrefix() {
        return this.targetPrefix;
    }

    public String getLabel() {
        return this.getTarget();
    }

    public int getPosition() {
        return this.position;
    }

    public int getEnd() {
        return this.end;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "=" + this.target + "[pos:" + this.position + ",end:" + this.end + ",lengthToNameEnd:" + this.lengthToNameEnd + "]";
    }

    public String getFullExpression() {
        return this.fullExpression;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

