/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.provider;

import de.jcup.asciidoctoreditor.LogAdapter;
import de.jcup.asciidoctoreditor.asciidoc.AsciidoctorAdapter;
import de.jcup.asciidoctoreditor.asciidoc.AsciidoctorConfigFile;
import de.jcup.asciidoctoreditor.asciidoc.AsiidocConfigFileSupport;
import de.jcup.asciidoctoreditor.provider.AbstractAsciiDoctorProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorAdapterProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorAttributesProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorBaseDirectoryProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorDiagramProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorImageProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorOptionsProvider;
import de.jcup.asciidoctoreditor.provider.ImageHandlingMode;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class AsciiDoctorProviderContext {
    private LogAdapter logAdapter;
    private File asciidocFile;
    private File baseDir;
    private Path outputFolder;
    private boolean tocVisible;
    private AsciiDoctorAdapterProvider provider;
    private AsciiDoctorBaseDirectoryProvider baseDirProvider;
    private AsciiDoctorImageProvider imageProvider;
    private AsciiDoctorDiagramProvider diagramProvider;
    private AsciiDoctorAttributesProvider attributesProvider;
    private AsciiDoctorOptionsProvider optionsProvider;
    int tocLevels;
    private boolean useInstalled;
    private File fileToRender;
    private ImageHandlingMode imageHandlingMode;
    private Set<AbstractAsciiDoctorProvider> providers = new LinkedHashSet<AbstractAsciiDoctorProvider>();
    private File editorFileOrNull;
    private boolean noFooter;
    private boolean internalPreview;
    private boolean localResourcesEnabled = true;
    private AsiidocConfigFileSupport configFileSupport;
    private List<AsciidoctorConfigFile> configFiles = new ArrayList<AsciidoctorConfigFile>();

    public AsciiDoctorProviderContext(AsciiDoctorAdapterProvider provider, LogAdapter logAdapter) {
        if (logAdapter == null) {
            throw new IllegalArgumentException("logAdapter may never be null!");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider may never be null!");
        }
        this.logAdapter = logAdapter;
        this.provider = provider;
        this.init();
    }

    public Path getOutputFolder() {
        return this.outputFolder;
    }

    public void setTocLevels(int tocLevels) {
        this.tocLevels = tocLevels;
    }

    public AsciiDoctorBaseDirectoryProvider getBaseDirProvider() {
        return this.baseDirProvider;
    }

    public AsciiDoctorImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public AsciiDoctorDiagramProvider getDiagramProvider() {
        return this.diagramProvider;
    }

    public AsciiDoctorAttributesProvider getAttributesProvider() {
        return this.attributesProvider;
    }

    public AsciiDoctorOptionsProvider getOptionsProvider() {
        return this.optionsProvider;
    }

    public void setAsciidocFile(File asciidocFile) {
        this.asciidocFile = asciidocFile;
        this.baseDir = this.baseDirProvider.findBaseDir();
    }

    public void setImageHandlingMode(ImageHandlingMode imageHandlingMode) {
        this.imageHandlingMode = imageHandlingMode;
    }

    public ImageHandlingMode getImageHandlingMode() {
        return this.imageHandlingMode;
    }

    protected void init() {
        this.logAdapter.resetTimeDiff();
        this.attributesProvider = this.register(new AsciiDoctorAttributesProvider(this));
        this.logAdapter.logTimeDiff("time to create attributes provider");
        this.imageProvider = this.register(new AsciiDoctorImageProvider(this));
        this.logAdapter.logTimeDiff("time to create images provider");
        this.optionsProvider = this.register(new AsciiDoctorOptionsProvider(this));
        this.logAdapter.logTimeDiff("time to create options provider");
        this.baseDirProvider = this.register(new AsciiDoctorBaseDirectoryProvider(this));
        this.logAdapter.logTimeDiff("time to create base dir provider");
        this.diagramProvider = this.register(new AsciiDoctorDiagramProvider(this));
        this.logAdapter.logTimeDiff("time to create diagram provider");
    }

    public void setOutputFolder(Path outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void resetCaches() {
        this.baseDir = null;
        this.outputFolder = null;
        for (AbstractAsciiDoctorProvider provider : this.providers) {
            provider.reset();
        }
    }

    public AsciidoctorAdapter getAsciiDoctor() {
        return this.getProvider().getAsciiDoctor(this.useInstalled);
    }

    protected AsciiDoctorAdapterProvider getProvider() {
        return this.provider;
    }

    public void setTOCVisible(boolean visible) {
        this.tocVisible = visible;
    }

    public boolean isTOCVisible() {
        return this.tocVisible;
    }

    public File getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = this.baseDirProvider.findBaseDir();
        }
        return this.baseDir;
    }

    public LogAdapter getLogAdapter() {
        return this.logAdapter;
    }

    public File getAsciiDocFile() {
        return this.asciidocFile;
    }

    public void setUseInstalled(boolean usingInstalledAsciidoctor) {
        this.useInstalled = usingInstalledAsciidoctor;
    }

    public boolean isUsingInstalledAsciiDoctor() {
        return this.useInstalled;
    }

    public void setFileToRender(File fileToRender) {
        this.fileToRender = fileToRender;
    }

    public File getFileToRender() {
        return this.fileToRender;
    }

    public File getTargetPDFFileOrNull() {
        if (this.fileToRender == null) {
            return null;
        }
        String originName = this.fileToRender.getName();
        String fileName = String.valueOf(FilenameUtils.getBaseName((String)originName)) + ".pdf";
        File file = new File(this.fileToRender.getParentFile(), fileName);
        return file;
    }

    public <T extends AbstractAsciiDoctorProvider> T register(T provider) {
        this.providers.add(provider);
        return provider;
    }

    public void setEditorFileOrNull(File editorFileOrNull) {
        this.editorFileOrNull = editorFileOrNull;
    }

    public File getEditorFileOrNull() {
        return this.editorFileOrNull;
    }

    public void setNoFooter(boolean noFooter) {
        this.noFooter = noFooter;
    }

    public boolean isNoFooter() {
        return this.noFooter;
    }

    public void setInternalPreview(boolean internalPreview) {
        this.internalPreview = internalPreview;
    }

    public boolean isInternalPreview() {
        return this.internalPreview;
    }

    public boolean isUsingOnlyLocalResources() {
        return this.internalPreview && this.localResourcesEnabled;
    }

    public void setConfigRootSupport(AsiidocConfigFileSupport support) {
        this.configFileSupport = support;
    }

    public AsiidocConfigFileSupport getConfigFileSupport() {
        return this.configFileSupport;
    }

    public void setConfigFiles(List<AsciidoctorConfigFile> configFiles) {
        this.configFiles.clear();
        this.configFiles.addAll(configFiles);
    }

    public List<AsciidoctorConfigFile> getConfigFiles() {
        return this.configFiles;
    }
}

