/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.provider;

import de.jcup.asciidoctoreditor.provider.AbstractAsciiDoctorProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorAttributesProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorProviderContext;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class AsciiDoctorImageProvider
extends AbstractAsciiDoctorProvider {
    private static ImageFilesFilter IMAGE_FILTER = new ImageFilesFilter();
    private String cachedSourceImagesPath;

    AsciiDoctorImageProvider(AsciiDoctorProviderContext context) {
        super(context);
    }

    public void ensureImageByRelativePath(String relativePath) {
        Path outputFolder = this.getContext().getOutputFolder();
        if (outputFolder == null) {
            throw new IllegalStateException("no output folder set!");
        }
        File baseDir = this.getContext().getBaseDir();
        File originImage = new File(baseDir, relativePath);
        if (!IMAGE_FILTER.accept(originImage)) {
            return;
        }
        File targetImage = new File(outputFolder.toFile(), relativePath);
        File parentFile = targetImage.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        try {
            FileUtils.copyFile((File)originImage, (File)targetImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getCachedSourceImagesPath() {
        if (this.cachedSourceImagesPath == null) {
            this.cachedSourceImagesPath = this.resolveImagesDirPath(this.getContext().getBaseDir());
        }
        return this.cachedSourceImagesPath;
    }

    protected String resolveImagesDirPath(File baseDir) {
        this.getContext().getLogAdapter().resetTimeDiff();
        AsciiDoctorAttributesProvider attributesProvider = this.getContext().getAttributesProvider();
        Map<String, Object> cachedAttributes = attributesProvider.getCachedAttributes();
        Object imagesDir = cachedAttributes.get("imagesdir");
        String imagesDirPath = null;
        if (imagesDir != null) {
            imagesDirPath = imagesDir.toString();
            if (imagesDirPath.startsWith("./")) {
                File imagePathNew = new File(baseDir, imagesDirPath.substring(2));
                imagesDirPath = imagePathNew.getAbsolutePath();
            }
        } else {
            imagesDirPath = baseDir.getAbsolutePath();
        }
        this.getContext().getLogAdapter().logTimeDiff("resolveImagesDirPath, baseDir:" + baseDir);
        return imagesDirPath;
    }

    @Override
    public void reset() {
        this.cachedSourceImagesPath = null;
    }

    private static class ImageFilesFilter
    implements FileFilter {
        private ImageFilesFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file == null || !file.exists()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String ext = FilenameUtils.getExtension((String)file.getName());
            if (ext == null || ext.isEmpty()) {
                return false;
            }
            String e = ext.toLowerCase();
            if ("png".equals(e)) {
                return true;
            }
            if ("jpg".equals(e)) {
                return true;
            }
            if ("gif".equals(e)) {
                return true;
            }
            if ("svg".equals(e)) {
                return true;
            }
            if ("bmp".equals(e)) {
                return true;
            }
            return "tiff".equals(e);
        }
    }
}

