/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.provider;

import de.jcup.asciidoctoreditor.asciidoc.AsciiDocFileFilter;
import de.jcup.asciidoctoreditor.provider.AbstractAsciiDoctorProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorProviderContext;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;

public class AsciiDoctorBaseDirectoryProvider
extends AbstractAsciiDoctorProvider {
    private static FileFilter ADOC_FILE_FILTER = new AsciiDocFileFilter(false);
    private Map<File, File> baseDirCache = new HashMap<File, File>();
    private File tempFolder;

    AsciiDoctorBaseDirectoryProvider(AsciiDoctorProviderContext context) {
        super(context);
    }

    public void setTempFolder(File tempFolder) {
        this.tempFolder = tempFolder;
    }

    public File getTempFolder() {
        if (this.tempFolder == null) {
            this.tempFolder = new File(System.getProperty("java.io.tmpdir"));
        }
        return this.tempFolder;
    }

    private File findBaseDirNotCached(File startFrom) {
        this.getContext().getLogAdapter().resetTimeDiff();
        File file = this.resolveUnSaveBaseDir(startFrom);
        File tempFolder = this.getTempFolder();
        if (tempFolder.equals(file)) {
            throw new IllegalStateException("Tempfolder may never be the base dir folder!\nTempfolder:" + tempFolder.getAbsolutePath());
        }
        this.getContext().getLogAdapter().logTimeDiff("findBaseDirNotCached, started from:" + startFrom + ", result:" + file);
        return file;
    }

    private File resolveUnSaveBaseDir(File dir) {
        if (dir == null) {
            return new File(".");
        }
        File parentFile = dir.getParentFile();
        if (this.getTempFolder().equals(parentFile)) {
            return dir;
        }
        if (this.containsADocFiles(parentFile)) {
            return this.findBaseDirNotCached(parentFile);
        }
        return dir;
    }

    private File findCachedBaseDirOrStartSearch(File startFrom) {
        if (startFrom == null) {
            throw new IllegalStateException("No start from defined - but must be!");
        }
        File cachedBaseDir = this.baseDirCache.get(startFrom);
        if (cachedBaseDir == null) {
            cachedBaseDir = this.findBaseDirNotCached(startFrom);
            this.baseDirCache.put(startFrom, cachedBaseDir);
        }
        return cachedBaseDir;
    }

    private boolean containsADocFiles(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles(ADOC_FILE_FILTER);
        return files.length != 0;
    }

    public File findBaseDir() {
        File asciiDocFile = this.getContext().getAsciiDocFile();
        if (asciiDocFile == null) {
            throw new IllegalStateException("No asciidoc file set!");
        }
        return this.findCachedBaseDirOrStartSearch(asciiDocFile.getParentFile());
    }

    @Override
    public void reset() {
        this.baseDirCache.clear();
    }
}

