/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.provider;

import de.jcup.asciidoctoreditor.asciidoc.AsiidocConfigFileSupport;
import de.jcup.asciidoctoreditor.provider.AbstractAsciiDoctorProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorProviderContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;

public class AsciiDoctorAttributesProvider
extends AbstractAsciiDoctorProvider {
    public static final String IMAGE_OUTPUT_DIR_NAME = "img";
    private Map<String, Object> cachedAttributes;

    AsciiDoctorAttributesProvider(AsciiDoctorProviderContext context) {
        super(context);
    }

    public Attributes createAttributes() {
        String imagesDirString;
        String absolutePathBaseDir = this.getContext().getBaseDir().getAbsolutePath();
        AttributesBuilder attrBuilder = AttributesBuilder.attributes().showTitle(true).noFooter(this.getContext().isNoFooter()).sourceHighlighter("coderay").attribute("eclipse-editor-basedir", (Object)absolutePathBaseDir).attribute("icons", (Object)"font").attribute("source-highlighter", (Object)"coderay").attribute("coderay-css", (Object)"style").attribute("env", (Object)"eclipse").attribute("env-eclipse");
        if (this.getContext().isTOCVisible()) {
            attrBuilder.attribute("toc", (Object)"left");
            if (this.getContext().tocLevels > 0) {
                attrBuilder.attribute("toclevels", (Object)("" + this.getContext().tocLevels));
            }
        } else {
            attrBuilder.attribute("!toc", (Object)"");
        }
        Attributes attrs = attrBuilder.get();
        String outputFolderAbsolutePath = this.createAbsolutePath(this.getOutputFolder());
        attrs.setAttribute("outdir", (Object)outputFolderAbsolutePath);
        Object imagesDir = this.getCachedAttributes().get("imagesdir");
        if (imagesDir instanceof String && (imagesDirString = (String)imagesDir).startsWith(".")) {
            File file = new File(absolutePathBaseDir, imagesDirString);
            try {
                attrs.setAttribute("imagesdir", (Object)file.getCanonicalPath());
            }
            catch (IOException iOException) {
                attrs.setAttribute("imagesdir", (Object)file.getAbsolutePath());
            }
        }
        this.handleImagesOutDirAttribute(attrs, absolutePathBaseDir, outputFolderAbsolutePath);
        return attrs;
    }

    private void handleImagesOutDirAttribute(Attributes attrs, String absolutePathBaseDir, String outputFolderAbsolutePath) {
        File target = new File(outputFolderAbsolutePath, IMAGE_OUTPUT_DIR_NAME);
        attrs.setAttribute("imagesoutdir", (Object)target.getAbsolutePath());
    }

    protected Map<String, Object> getCachedAttributes() {
        if (this.cachedAttributes == null) {
            this.cachedAttributes = this.resolveAttributes();
        }
        return this.cachedAttributes;
    }

    protected Map<String, Object> resolveAttributes() {
        AsciiDoctorProviderContext context = this.getContext();
        Map<String, Object> map = this.getContext().getAsciiDoctor().resolveAttributes(context.getAsciiDocFile());
        AsiidocConfigFileSupport support = this.getContext().getConfigFileSupport();
        return support.calculateResolvedMap(map, this.getContext().getConfigFiles());
    }

    protected String createAbsolutePath(Path path) {
        return path.toAbsolutePath().normalize().toString();
    }

    @Override
    public void reset() {
        this.cachedAttributes = null;
    }
}

