/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.preview;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.preview.EnsureFileRunnable;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class WaitForGeneratedFileAndShowInsideExternalPreviewPreviewRunner
implements EnsureFileRunnable {
    private final AsciiDoctorEditor asciiDoctorEditor;
    private IProgressMonitor monitor;

    public WaitForGeneratedFileAndShowInsideExternalPreviewPreviewRunner(AsciiDoctorEditor asciiDoctorEditor, IProgressMonitor monitor) {
        this.asciiDoctorEditor = asciiDoctorEditor;
        this.monitor = monitor;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        try {
            File temporaryExternalPreviewFile = this.asciiDoctorEditor.getTemporaryExternalPreviewFile();
            while (this.asciiDoctorEditor.isNotCanceled(this.monitor) && (temporaryExternalPreviewFile == null || !temporaryExternalPreviewFile.exists())) {
                if (System.currentTimeMillis() - start > 20000L) {
                    EclipseUtil.safeAsyncExec(() -> MessageDialog.openWarning((Shell)EclipseUtil.getActiveWorkbenchShell(), (String)"Asciidoctor Editor", (String)"Generated HTML output not found - maybe it's still in generation.\n\nPlease wait and try again."));
                    return;
                }
                Thread.sleep(300L);
            }
            AsciiDoctorEditorUtil.openFileInExternalBrowser(temporaryExternalPreviewFile);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

