/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.preview;

import de.jcup.asciidoctoreditor.AsciiDoctorEclipseLogAdapter;
import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.EclipseDevelopmentSettings;
import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.outline.ItemType;
import de.jcup.asciidoctoreditor.script.AsciidoctorTextSelectable;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public class ScrollSynchronizer {
    private AsciiDoctorEditor editor;
    private ScrollSyncMouseListener scrollSyncListener;
    private boolean ignoreNextTreeSelectionChangeEvent;

    public ScrollSynchronizer(AsciiDoctorEditor editor) {
        this.editor = editor;
        this.scrollSyncListener = new ScrollSyncMouseListener();
    }

    public void installInBrowser() {
        this.editor.getBrowserAccess().install((MouseListener)this.scrollSyncListener);
    }

    private void onMouseClickInBrowser(String elementId) {
        if (!this.editor.getPreferences().isLinkEditorWithPreviewEnabled()) {
            return;
        }
        if (elementId == null) {
            return;
        }
        AsciidoctorTextSelectable selectable = this.editor.findAsciiDoctorPositionByElementId(elementId);
        if (selectable == null) {
            return;
        }
        int offset = selectable.getSelectionStart();
        if (offset < 0) {
            return;
        }
        this.editor.setFocus();
        this.editor.selectAndReveal(offset, selectable.getSelectionLength());
        this.ignoreNextTreeSelectionChangeEvent = true;
        this.editor.getOutlineSupport().selectItemPointingTo(selectable.getPosition());
    }

    public void onEditorCaretMoved(int caretOffset) {
        if (!this.editor.getPreferences().isLinkEditorWithPreviewEnabled()) {
            return;
        }
        if (!this.editor.isInternalPreview()) {
            return;
        }
        Item item = this.editor.getItemAt(caretOffset);
        if (item == null) {
            return;
        }
        if (EclipseDevelopmentSettings.DEBUG_LOGGING_ENABLED) {
            AsciiDoctorEclipseLogAdapter.INSTANCE.logInfo("Editor caret moved to item:" + item);
        }
        this.handleScrollToHeadlineIfPossible(item);
        this.handleScrollToAnchorIfPossible(item);
    }

    private void handleScrollToHeadlineIfPossible(Item item) {
        ItemType itemType = item.getItemType();
        if (!ItemType.HEADLINE.equals((Object)itemType)) {
            return;
        }
        this.jumpToElementWithItemId(item);
    }

    private void handleScrollToAnchorIfPossible(Item item) {
        ItemType itemType = item.getItemType();
        if (!ItemType.INLINE_ANCHOR.equals((Object)itemType)) {
            return;
        }
        this.jumpToElementWithItemId(item);
    }

    protected void jumpToElementWithItemId(Item item) {
        if (this.ignoreNextTreeSelectionChangeEvent) {
            this.ignoreNextTreeSelectionChangeEvent = false;
            return;
        }
        String anchorId = item.getId();
        if (EclipseDevelopmentSettings.DEBUG_LOGGING_ENABLED) {
            AsciiDoctorEclipseLogAdapter.INSTANCE.logInfo("Item has anchor id:" + anchorId);
        }
        if (anchorId == null) {
            this.editor.getBrowserAccess().navgigateToTopOfView();
            return;
        }
        String javascript = "doScrollTo('" + anchorId + "')";
        if (EclipseDevelopmentSettings.DEBUG_LOGGING_ENABLED) {
            AsciiDoctorEclipseLogAdapter.INSTANCE.logInfo("Call browser access with javascript:" + javascript);
        }
        this.editor.getBrowserAccess().safeBrowserExecuteJavascript(javascript);
    }

    class ScrollSyncMouseListener
    extends MouseAdapter {
        ScrollSyncMouseListener() {
        }

        public void mouseUp(MouseEvent e) {
            String javascript = "var element=document.elementFromPoint(" + e.x + "," + e.y + ");" + "if (element!=null){ return element.getAttribute('id')} else {return null};";
            String elementId = (String)ScrollSynchronizer.this.editor.getBrowserAccess().safeBrowserEvaluateJavascript(javascript);
            ScrollSynchronizer.this.onMouseClickInBrowser(elementId);
        }
    }
}

