/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.preview;

import de.jcup.asciidoctoreditor.AsciiDoctorEclipseLogAdapter;
import de.jcup.asciidoctoreditor.EclipseDevelopmentSettings;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;

public class BrowserAccess {
    private Browser browser;
    private Object monitor = new Object();
    private Composite sashForm;
    private MouseListener listener;

    public void setEnabled(boolean enabled) {
        this.safeSetBrowserVisible(enabled);
    }

    public BrowserAccess(Composite parent) {
        this.sashForm = parent;
    }

    public void refresh() {
        if (this.isBrowserNotAvailable()) {
            return;
        }
        this.browser.refresh();
    }

    private void safeSetBrowserVisible(boolean visible) {
        if (this.isBrowserNotAvailable()) {
            return;
        }
        this.browser.setVisible(visible);
    }

    public void navgigateToTopOfView() {
        this.safeBrowserExecuteJavascript("scroll(0,0)");
    }

    public void dispose() {
        if (this.browser == null) {
            return;
        }
        if (this.listener != null && !this.browser.isDisposed()) {
            this.browser.removeMouseListener(this.listener);
        }
        if (!this.browser.isDisposed()) {
            this.browser.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Browser ensureBrowser(final BrowserContentInitializer initializer) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.browser == null) {
                this.browser = new Browser(this.sashForm, 0x1000000);
                Job job = Job.create((String)"Init browser", (ICoreRunnable)new ICoreRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        monitor.beginTask("Initializing browser", -1);
                        initializer.initialize(BrowserAccess.this.browser);
                        monitor.done();
                    }
                });
                job.schedule();
            }
            return this.browser;
        }
    }

    public void safeBrowserSetText(final String html) {
        if (this.isBrowserNotAvailable()) {
            return;
        }
        EclipseUtil.safeAsyncExec(new Runnable(){

            @Override
            public void run() {
                if (BrowserAccess.this.isBrowserNotAvailable()) {
                    return;
                }
                BrowserAccess.this.browser.setText(html);
            }
        });
    }

    public void install(MouseListener mouseListener) {
        if (this.isBrowserNotAvailable()) {
            return;
        }
        if (this.listener != null) {
            this.browser.removeMouseListener(this.listener);
        }
        this.listener = mouseListener;
        this.browser.addMouseListener(this.listener);
    }

    public void safeBrowserExecuteJavascript(final String javascript) {
        if (this.isBrowserNotAvailable()) {
            return;
        }
        EclipseUtil.safeAsyncExec(new Runnable(){

            @Override
            public void run() {
                if (BrowserAccess.this.isBrowserNotAvailable()) {
                    return;
                }
                if (EclipseDevelopmentSettings.DEBUG_LOGGING_ENABLED) {
                    AsciiDoctorEclipseLogAdapter.INSTANCE.logInfo("safeBrowserExecuteJavascript, sending javascript:" + javascript);
                }
                try {
                    BrowserAccess.this.browser.evaluate(javascript);
                }
                catch (RuntimeException e) {
                    AsciiDoctorEclipseLogAdapter.INSTANCE.logError("Was not able to execute javascript:" + javascript, e);
                }
            }
        });
    }

    public String getUrl() {
        if (this.isBrowserNotAvailable()) {
            return "";
        }
        return this.browser.getUrl();
    }

    protected boolean isBrowserNotAvailable() {
        return this.browser == null || this.browser.isDisposed();
    }

    public void setUrl(String url) {
        if (this.isBrowserNotAvailable()) {
            return;
        }
        this.browser.setUrl(url);
    }

    public <T> T safeBrowserEvaluateJavascript(String javascript) {
        if (this.isBrowserNotAvailable()) {
            return null;
        }
        Object result = null;
        try {
            result = this.browser.evaluate(javascript);
        }
        catch (RuntimeException e) {
            AsciiDoctorEclipseLogAdapter.INSTANCE.logError("Was not able to execute javascript:" + javascript, e);
        }
        return (T)result;
    }

    public static interface BrowserContentInitializer {
        public void initialize(Browser var1);
    }
}

