/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.preview;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.AsciidoctorHTMLOutputParser;
import de.jcup.asciidoctoreditor.ContentTransformerData;
import de.jcup.asciidoctoreditor.EclipseDevelopmentSettings;
import de.jcup.asciidoctoreditor.TemporaryFileType;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocFileUtils;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocStringUtils;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorBackendType;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorWrapper;
import de.jcup.asciidoctoreditor.asciidoc.InstalledAsciidoctorException;
import de.jcup.asciidoctoreditor.asciidoc.Sha256StringEncoder;
import de.jcup.asciidoctoreditor.asciidoc.WrapperConvertData;
import de.jcup.asciidoctoreditor.asp.AspCompatibleProgressMonitorAdapter;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.preview.BuildDoneListener;
import de.jcup.asciidoctoreditor.preview.Worked;
import de.jcup.asciidoctoreditor.script.AsciiDoctorErrorBuilder;
import de.jcup.asciidoctoreditor.script.AsciiDoctorMarker;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorPart;

class AsciidocEditorPreviewBuildRunnnable
implements ICoreRunnable {
    public static final Sha256StringEncoder STRING_ENCODER = new Sha256StringEncoder();
    BuildDoneListener buildDoneListener;
    AsciiDoctorBackendType backend;
    boolean internalPreview;
    AsciiDoctorEditor editor;
    private Worked worked = new Worked();

    AsciidocEditorPreviewBuildRunnnable() {
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            this.before(monitor);
            this.buildHTMLPreviewFile(monitor);
            this.after(monitor);
        }
        finally {
            this.editor.getOutputBuildSemaphore().release();
        }
    }

    private void buildHTMLPreviewFile(IProgressMonitor monitor) {
        if (this.isCanceled(monitor)) {
            return;
        }
        AsciiDoctorWrapper asciidocWrapper = this.editor.getWrapper();
        File outputFile = null;
        try {
            String originalAsciidocHTML;
            EclipseUtil.safeAsyncExec(() -> AsciiDoctorEditorUtil.removeScriptErrors((IEditorPart)this.editor));
            monitor.subTask("RESOLVE");
            File editorFileOrNull = this.editor.getEditorFileOrNull();
            File tempAsciiDocFileToConvertIntoHTML = this.createTransformedTempFileOrNull(editorFileOrNull);
            if (tempAsciiDocFileToConvertIntoHTML == null) {
                return;
            }
            if (this.isCanceled(monitor)) {
                return;
            }
            this.increaseWorked(monitor);
            monitor.subTask("GENERATE");
            this.convertTempAsciidocFileToHTML(monitor, asciidocWrapper, editorFileOrNull, tempAsciiDocFileToConvertIntoHTML);
            this.increaseWorked(monitor);
            if (this.isCanceled(monitor)) {
                return;
            }
            monitor.subTask("READ AND TRANSFORM");
            File fileToRender = asciidocWrapper.getContext().getFileToRender();
            String asciidocHTML = originalAsciidocHTML = this.readFileCreatedByAsciiDoctor(fileToRender, this.editor.getEditorId());
            this.increaseWorked(monitor);
            asciidocHTML = this.fixImageLocationPathesInsideHTML(asciidocWrapper, asciidocHTML);
            if (this.isCanceled(monitor)) {
                return;
            }
            this.increaseWorked(monitor);
            outputFile = this.enrichPreviewHTMLAndWriteToDisk(monitor, asciidocWrapper, asciidocHTML);
        }
        catch (Throwable e) {
            this.writeFallbackWhenPreviewFileWasNotWritten(e);
        }
        if (EclipseDevelopmentSettings.DEBUG_LOGGING_ENABLED) {
            System.out.println("worked:" + this.worked);
            System.out.println("outputFile:" + outputFile);
        }
    }

    private String fixImageLocationPathesInsideHTML(AsciiDoctorWrapper asciidocWrapper, String asciidocHTML) throws IOException {
        AsciidoctorHTMLOutputParser parser = new AsciidoctorHTMLOutputParser();
        File tempFolder = asciidocWrapper.getTempFolder().toFile();
        File imageOutDir = new File(tempFolder, "img");
        Set<String> pathes = parser.findImageSourcePathes(asciidocHTML);
        for (String path : pathes) {
            File file;
            if (path == null || path.indexOf("://") != -1 || (file = new File(path)).exists()) continue;
            String p2 = file.getPath();
            String replacePath = null;
            if (p2.startsWith(".") && (file = new File(asciidocWrapper.getContext().getBaseDir(), p2)).exists()) {
                replacePath = file.getCanonicalPath();
            }
            if (replacePath == null) {
                replacePath = new File(imageOutDir, file.getName()).getCanonicalPath();
            }
            asciidocHTML = asciidocHTML.replace(path, replacePath);
        }
        return asciidocHTML;
    }

    private void increaseWorked(IProgressMonitor monitor) {
        monitor.worked(++this.worked.amount);
    }

    private void convertTempAsciidocFileToHTML(IProgressMonitor monitor, AsciiDoctorWrapper asciidocWrapper, File editorFileOrNull, File tempFileToConvertIntoHTML) throws Exception {
        WrapperConvertData wrapperConvertData = this.createWrapperData(editorFileOrNull, tempFileToConvertIntoHTML);
        this.editor.beforeAsciidocConvert(wrapperConvertData);
        asciidocWrapper.convert(wrapperConvertData, this.backend, new AspCompatibleProgressMonitorAdapter(monitor));
    }

    private WrapperConvertData createWrapperData(File editorFileOrNull, File fileToConvertIntoHTML) {
        WrapperConvertData data = new WrapperConvertData();
        data.targetType = this.editor.getType();
        data.asciiDocFile = fileToConvertIntoHTML;
        data.editorId = this.editor.getEditorId();
        data.useHiddenFile = this.isNeedingAHiddenEditorFile(editorFileOrNull, fileToConvertIntoHTML);
        data.editorFileOrNull = editorFileOrNull;
        data.internalPreview = this.internalPreview;
        return data;
    }

    private File createTransformedTempFileOrNull(File editorFileOrNull) throws IOException {
        File fileToConvertIntoHTML = null;
        if (editorFileOrNull == null) {
            String asciiDoc = this.editor.getDocumentText();
            fileToConvertIntoHTML = this.createTransformedTempFileFromTextContent(asciiDoc);
        } else {
            fileToConvertIntoHTML = this.createTransformedTempFileFromEditorFile(editorFileOrNull);
        }
        return fileToConvertIntoHTML;
    }

    private void writeFallbackWhenPreviewFileWasNotWritten(Throwable e) {
        StringBuilder htmlSb = new StringBuilder();
        htmlSb.append("<h4");
        if (this.editor.isAsciiDoctorError(e)) {
            htmlSb.append("Asciidoctor error");
        } else {
            htmlSb.append("Unknown error");
        }
        htmlSb.append("</h4");
        EclipseUtil.safeAsyncExec(() -> {
            String errorMessage = this.editor.fetchAsciidoctorErrorMessage(e);
            AsciiDoctorErrorBuilder builder = new AsciiDoctorErrorBuilder();
            AsciiDoctorMarker error = builder.build(errorMessage);
            this.editor.getBrowserAccess().safeBrowserSetText(htmlSb.toString());
            AsciiDoctorEditorUtil.addAsciiDoctorMarker((IEditorPart)this.editor, -1, error, 2);
            if (this.isLoggingNecessary(e)) {
                AsciiDoctorEditorUtil.logError("AsciiDoctor error occured:" + e.getMessage(), e);
            }
        });
    }

    private File enrichPreviewHTMLAndWriteToDisk(IProgressMonitor monitor, AsciiDoctorWrapper asciidocWrapper, String asciiDocHtml) {
        String previewHTML;
        if (this.internalPreview) {
            previewHTML = asciidocWrapper.enrichHTML(asciiDocHtml, 0);
        } else {
            int refreshAutomaticallyInSeconds = AsciiDoctorEditorPreferences.getInstance().getAutoRefreshInSecondsForExternalBrowser();
            previewHTML = asciidocWrapper.enrichHTML(asciiDocHtml, refreshAutomaticallyInSeconds);
        }
        return this.writePreviewHTMLFile(monitor, previewHTML);
    }

    private File writePreviewHTMLFile(IProgressMonitor monitor, String previewHTML) {
        File outputFile = null;
        try {
            if (this.internalPreview) {
                monitor.subTask("WRITE INTERNAL PREVIEW");
                outputFile = this.editor.getTemporaryInternalPreviewFile();
            } else {
                monitor.subTask("WRITE EXTERNAL PREVIEW");
                outputFile = this.editor.getTemporaryExternalPreviewFile();
            }
            AsciiDocStringUtils.writeTextToUTF8File(previewHTML, outputFile);
            this.increaseWorked(monitor);
        }
        catch (IOException e1) {
            AsciiDoctorEditorUtil.logError("Was not able to save temporary files for preview!", e1);
        }
        return outputFile;
    }

    private File createTransformedTempFileFromTextContent(String asciiDoc) throws IOException {
        String text;
        if (this.editor.getContentTransformer().isTransforming(asciiDoc)) {
            ContentTransformerData data = new ContentTransformerData();
            data.origin = asciiDoc;
            text = this.editor.getContentTransformer().transform(data);
        } else {
            text = asciiDoc;
        }
        File fileToConvertIntoHTML = this.createTransformedTempfile("no_origin_file_defined", text);
        return fileToConvertIntoHTML;
    }

    private File createTransformedTempFileFromEditorFile(File editorFile) throws IOException {
        if (editorFile == null || !editorFile.exists()) {
            return null;
        }
        String originText = AsciiDocStringUtils.readUTF8FileToString(editorFile);
        if (originText == null) {
            return null;
        }
        if (!this.editor.getContentTransformer().isTransforming(originText)) {
            return editorFile;
        }
        return this.createTransformedTempfile(editorFile.getName(), originText);
    }

    private File createTransformedTempfile(String filename, String text) throws IOException {
        Path tempFolder = this.editor.getWrapper().getTempFolder();
        File newTempFile = AsciiDocFileUtils.createTempFileForConvertedContent(tempFolder, this.editor.getEditorId(), filename);
        ContentTransformerData data = new ContentTransformerData();
        data.origin = text;
        data.filename = filename;
        String transformed = this.editor.getContentTransformer().transform(data);
        try {
            return AsciiDocStringUtils.writeTextToUTF8File(transformed, newTempFile);
        }
        catch (IOException e) {
            EclipseUtil.logError("Was not able to write transformed file:" + filename, e);
            return null;
        }
    }

    private String readFileCreatedByAsciiDoctor(File fileToConvertIntoHTML, long editorId) {
        File generatedFile = this.editor.getWrapper().getTempFileFor(fileToConvertIntoHTML, editorId, TemporaryFileType.ORIGIN);
        try {
            return AsciiDocStringUtils.readUTF8FileToString(generatedFile);
        }
        catch (IOException e) {
            AsciiDoctorEditorUtil.logError("Was not able to build new full html variant", e);
            return "";
        }
    }

    private String getSafeFileName() {
        if (this.editor.getTemporaryInternalPreviewFile() == null) {
            return "<unknown>";
        }
        return this.editor.getTemporaryInternalPreviewFile().getName();
    }

    private boolean isNeedingAHiddenEditorFile(File editorFileOrNull, File fileToConvertIntoHTML) {
        return fileToConvertIntoHTML.equals(editorFileOrNull);
    }

    private boolean isLoggingNecessary(Throwable e) {
        return e != null && !(e instanceof InstalledAsciidoctorException);
    }

    private void before(IProgressMonitor monitor) {
        monitor.beginTask("Building document " + this.getSafeFileName(), 7);
    }

    private void after(IProgressMonitor monitor) {
        if (this.editor.isInternalPreview()) {
            monitor.subTask("show internal");
            this.editor.ensureInternalBrowserShowsURL(monitor);
        }
        monitor.worked(7);
        this.handleBuildDone(this.buildDoneListener);
        monitor.done();
    }

    private void ensureFocused() {
        if (this.editor.isInternalPreview()) {
            EclipseUtil.safeAsyncExec(() -> this.editor.refocus());
        }
    }

    private void handleBuildDone(BuildDoneListener buildDoneListener) {
        this.ensureFocused();
        if (buildDoneListener != null) {
            buildDoneListener.buildDone();
        }
    }

    public boolean isCanceled(IProgressMonitor monitor) {
        if (monitor == null) {
            return false;
        }
        return monitor.isCanceled();
    }
}

