/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.preview;

import de.jcup.asciidoctoreditor.AbstractAsciiDoctorEditorSupport;
import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorBackendType;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.preview.AsciidocBuildAndPreviewJobFactory;
import de.jcup.asciidoctoreditor.preview.BrowserAccess;
import de.jcup.asciidoctoreditor.preview.BuildAsciiDocMode;
import de.jcup.asciidoctoreditor.preview.BuildDoneListener;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.jobs.Job;

public class AsciiDoctorEditorBuildSupport
extends AbstractAsciiDoctorEditorSupport {
    private AsciidocBuildAndPreviewJobFactory factory = new AsciidocBuildAndPreviewJobFactory(this.getEditor());
    private static String previewFileURL = null;
    private static final String INITIALIZE_FALLBACK_HTML = "<html><body><h3>Initializing document</h3></body></html>";

    public AsciiDoctorEditorBuildSupport(AsciiDoctorEditor editor) {
        super(editor);
    }

    public void build(BuildAsciiDocMode mode, boolean internalPreview) {
        this.buildFullHTMLRebuildAsJobAndShowRebuildingInPreview(mode, AsciiDoctorBackendType.HTML5, false, internalPreview, new RevalidateAfterBuildListener());
    }

    private void buildFullHTMLRebuildAsJobAndShowRebuildingInPreview(BuildAsciiDocMode mode, AsciiDoctorBackendType backend, boolean forceInitialize, boolean internalPreview, BuildDoneListener buildDoneListener) {
        this.getEditor().validate();
        boolean rebuildEnabled = true;
        boolean internalPreview2 = this.getEditor().isInternalPreview();
        if (BuildAsciiDocMode.NOT_WHEN_EXTERNAL_PREVIEW_DISABLED == mode && !internalPreview2) {
            rebuildEnabled = AsciiDoctorEditorPreferences.getInstance().isAutoBuildEnabledForExternalPreview();
        }
        if (!rebuildEnabled) {
            return;
        }
        if (!forceInitialize && this.getEditor().getOutputBuildSemaphore().availablePermits() == 0) {
            return;
        }
        boolean initializing = forceInitialize || this.isFileNotAvailable(this.getEditor().getTemporaryInternalPreviewFile());
        this.showInitializingInfoWhenNecessary(initializing);
        this.triggerBuildAndRefreshJob(backend, internalPreview, buildDoneListener, initializing);
    }

    private void showInitializingInfoWhenNecessary(boolean initializing) {
        try {
            this.getEditor().getOutputBuildSemaphore().acquire();
            if (initializing) {
                AsciiDoctorEditorBuildSupport.showInitializingInfo(this.getEditor());
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void showInitializingInfo(AsciiDoctorEditor editor) {
        BrowserAccess browserAccess = editor.getBrowserAccess();
        if (previewFileURL == null) {
            previewFileURL = "";
            File previewInitializingFile = new File(editor.getWrapper().getAddonsFolder(), "html/initialize/preview_initializing.html");
            if (previewInitializingFile.exists()) {
                try {
                    previewFileURL = previewInitializingFile.toURI().toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    EclipseUtil.logError("Preview initializer html file not valid url", e);
                }
            }
        }
        if (previewFileURL.equals("")) {
            browserAccess.safeBrowserSetText(INITIALIZE_FALLBACK_HTML);
        } else {
            browserAccess.setUrl(previewFileURL);
        }
    }

    private void triggerBuildAndRefreshJob(AsciiDoctorBackendType backend, boolean internalPreview, BuildDoneListener buildDoneListener, boolean initializing) {
        String jobName = null;
        jobName = initializing ? "Asciidoctor editor preview initializing " : "Asciidoctor editor full rebuild";
        Job job = this.factory.createBuildAndPreviewJob(backend, internalPreview, buildDoneListener, jobName);
        job.schedule();
    }

    private class RevalidateAfterBuildListener
    implements BuildDoneListener {
        private RevalidateAfterBuildListener() {
        }

        @Override
        public void buildDone() {
            AsciiDoctorEditorBuildSupport.this.getEditor().rebuildOutlineAndValidate();
        }
    }
}

