/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.preview;

import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorWrapper;
import java.net.URI;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class AbsolutePathPatternFactory {
    public Pattern createRemoveAbsolutePathToTempFolderPattern(AsciiDoctorWrapper wrapper) {
        Path folder = wrapper.getTempFolder();
        return this.createRemoveAbsolutePathPattern(folder);
    }

    public Pattern createRemoveAbsolutePathToBaseFolderPattern(AsciiDoctorWrapper wrapper) {
        Path folder = wrapper.getContext().getBaseDir().toPath();
        return this.createRemoveAbsolutePathPattern(folder);
    }

    private Pattern createRemoveAbsolutePathPattern(Path folder) {
        URI absolutePathToTempFolder = folder.toFile().toURI();
        String path = absolutePathToTempFolder.getRawPath();
        if (this.isWindowsOS() && path.startsWith("/")) {
            path = path.substring(1);
        }
        return Pattern.compile(Pattern.quote(path));
    }

    private boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().contains("windows");
    }
}

