/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.preferences;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.PreviewLayout;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLOutputFormat;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferenceConstants;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorSyntaxColorPreferenceConstants;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorValidationPreferenceConstants;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorPlantUMLEditorPreferenceConstants;
import de.jcup.asciidoctoreditor.preferences.PreferenceIdentifiable;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import de.jcup.eclipse.commons.ui.ColorUtil;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AsciiDoctorEditorPreferences {
    private static AsciiDoctorEditorPreferences INSTANCE = new AsciiDoctorEditorPreferences();
    private IPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "de.jcup.asciidoctoreditor");

    public static AsciiDoctorEditorPreferences getInstance() {
        return INSTANCE;
    }

    private AsciiDoctorEditorPreferences() {
        this.store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Enum c;
                if (event == null) {
                    return;
                }
                String property = event.getProperty();
                if (property == null) {
                    return;
                }
                ChangeContext context = new ChangeContext();
                Enum[] enumArray = AsciiDoctorEditorSyntaxColorPreferenceConstants.values();
                int n = enumArray.length;
                int n2 = 0;
                while (n2 < n) {
                    c = enumArray[n2];
                    if (property.equals(((AsciiDoctorEditorSyntaxColorPreferenceConstants)c).getId())) {
                        context.colorChanged = true;
                        break;
                    }
                    ++n2;
                }
                enumArray = AsciiDoctorEditorValidationPreferenceConstants.values();
                n = enumArray.length;
                n2 = 0;
                while (n2 < n) {
                    c = enumArray[n2];
                    if (property.equals(((AsciiDoctorEditorValidationPreferenceConstants)c).getId())) {
                        context.validationChanged = true;
                        break;
                    }
                    ++n2;
                }
                this.updateColorsInAsciiDoctorEditors(context);
            }

            private void updateColorsInAsciiDoctorEditors(ChangeContext context) {
                IEditorReference[] references;
                if (!context.hasChanges()) {
                    return;
                }
                IWorkbenchPage activePage = EclipseUtil.getActivePage();
                if (activePage == null) {
                    return;
                }
                IEditorReference[] iEditorReferenceArray = references = activePage.getEditorReferences();
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference ref = iEditorReferenceArray[n2];
                    IEditorPart editor = ref.getEditor(false);
                    if (editor != null && editor instanceof AsciiDoctorEditor) {
                        AsciiDoctorEditor geditor = (AsciiDoctorEditor)editor;
                        if (context.colorChanged) {
                            geditor.handleColorSettingsChanged();
                        }
                        if (context.validationChanged) {
                            geditor.validate();
                        }
                    }
                    ++n2;
                }
            }
        });
    }

    public String getStringPreference(PreferenceIdentifiable id) {
        String data = this.getPreferenceStore().getString(id.getId());
        if (data == null) {
            data = "";
        }
        return data;
    }

    public int getIntegerPreference(PreferenceIdentifiable id) {
        int data = this.getPreferenceStore().getInt(id.getId());
        return data;
    }

    public boolean getBooleanPreference(PreferenceIdentifiable id) {
        boolean data = this.getPreferenceStore().getBoolean(id.getId());
        return data;
    }

    public void setBooleanPreference(PreferenceIdentifiable id, boolean value) {
        this.getPreferenceStore().setValue(id.getId(), value);
    }

    public void setStringPreference(PreferenceIdentifiable id, String value) {
        this.getPreferenceStore().setValue(id.getId(), value);
    }

    public boolean getDefaultBooleanPreference(PreferenceIdentifiable id) {
        boolean data = this.getPreferenceStore().getDefaultBoolean(id.getId());
        return data;
    }

    public RGB getColor(PreferenceIdentifiable identifiable) {
        RGB color = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)identifiable.getId());
        return color;
    }

    public String getWebColor(PreferenceIdentifiable identifiable) {
        RGB color = this.getColor(identifiable);
        if (color == null) {
            return null;
        }
        String webColor = ColorUtil.convertToHexColor((RGB)color);
        return webColor;
    }

    public void setDefaultColor(PreferenceIdentifiable identifiable, RGB color) {
        PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)identifiable.getId(), (RGB)color);
    }

    public boolean isLinkOutlineWithEditorEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_LINK_OUTLINE_WITH_EDITOR);
    }

    public boolean isLinkEditorWithPreviewEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_LINK_EDITOR_WITH_PREVIEW);
    }

    public boolean isAutoBuildEnabledForExternalPreview() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_EDITOR_AUTOBUILD_FOR_EXTERNAL_PREVIEW_ENABLED);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.store;
    }

    public int getAutoRefreshInSecondsForExternalBrowser() {
        if (!this.isAutoBuildEnabledForExternalPreview()) {
            return 0;
        }
        return this.getPreferenceStore().getInt(AsciiDoctorEditorPreferenceConstants.P_EDITOR_AUTOREFRESH_EXTERNAL_BROWSER_IN_SECONDS.getId());
    }

    public PreviewLayout getInitialLayoutModeForNewEditors() {
        String layoutMode = this.getStringPreference(AsciiDoctorEditorPreferenceConstants.P_EDITOR_NEWEDITOR_PREVIEW_LAYOUT);
        PreviewLayout layout = PreviewLayout.fromId(layoutMode);
        if (layout == null) {
            layout = PreviewLayout.VERTICAL;
        }
        return layout;
    }

    public boolean isUsingInstalledAsciidoctor() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_USE_INSTALLED_ASCIIDOCTOR_ENABLED);
    }

    public String getArgumentsForInstalledAsciidoctor() {
        return this.getStringPreference(AsciiDoctorEditorPreferenceConstants.P_INSTALLED_ASCIICDOCTOR_ARGUMENTS);
    }

    public boolean isConsoleAlwaysShownOnError() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_SHOW_ASCIIDOC_CONSOLE_ON_ERROR_OUTPUT);
    }

    public String getPathToInstalledAsciidoctor() {
        return this.getStringPreference(AsciiDoctorEditorPreferenceConstants.P_PATH_TO_INSTALLED_ASCIICDOCTOR);
    }

    public boolean isUsingPreviewImageDirectory() {
        return true;
    }

    public int getAspServerMinPort() {
        return this.getPreferenceStore().getInt(AsciiDoctorEditorPreferenceConstants.P_ASP_SERVER_MIN_PORT.getId());
    }

    public int getAspServerMaxPort() {
        return this.getPreferenceStore().getInt(AsciiDoctorEditorPreferenceConstants.P_ASP_SERVER_MAX_PORT.getId());
    }

    public boolean isURLValidationEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorValidationPreferenceConstants.VALIDATE_URLS);
    }

    public boolean isIncludeValidationEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorValidationPreferenceConstants.VALIDATE_INCLUDES);
    }

    public boolean isImageValidationEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorValidationPreferenceConstants.VALIDATE_IMAGES);
    }

    public boolean isDiagramValidationEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorValidationPreferenceConstants.VALIDATE_DIAGRAMS);
    }

    public boolean isShowingAspLogsAsMarkerInEditor() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_ASP_SERVER_LOGS_SHOWN_AS_MARKER_IN_EDITOR);
    }

    public boolean isShowingAspServerOutputInConsole() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_ASP_SERVER_OUTPUT_SHOWN_IN_CONSOLE);
    }

    public boolean isShowingAspCommunicationInConsole() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_ASP_COMMUNICATION_SHOWN_IN_CONSOLE);
    }

    public boolean isDynamicCodeAssistForIncludesEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_CODE_ASSIST_DYNAMIC_FOR_INCLUDES);
    }

    public boolean isDynamicCodeAssistForImagesEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_CODE_ASSIST_DYNAMIC_FOR_IMAGES);
    }

    public boolean isDynamicCodeAssistForPlantumlEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_CODE_ASSIST_DYNAMIC_FOR_PLANTUML_MACRO);
    }

    public boolean isDynamicCodeAssistForDitaaEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_CODE_ASSIST_DYNAMIC_FOR_DITAA_MACRO);
    }

    public String getPathToJavaBinaryForASPLaunch() {
        return this.getStringPreference(AsciiDoctorEditorPreferenceConstants.P_PATH_TO_JAVA_BINARY_FOR_ASP_LAUNCH);
    }

    public boolean isGroupingInOutlineEnabledPerDefault() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_OUTLINE_GROUPING_ENABLED_PER_DEFAULT);
    }

    public boolean isStoringPlantUmlFiles() {
        return this.getPreferenceStore().getBoolean(AsciiDoctorPlantUMLEditorPreferenceConstants.P_PLANTUML_EDITOR_STORE_DIAGRAMS_IN_PROJECT.getId());
    }

    public PlantUMLOutputFormat getPlantUMLOutputFormat() {
        return PlantUMLOutputFormat.fromString(this.getStringPreference(AsciiDoctorPlantUMLEditorPreferenceConstants.P_PLANTUML_EDITOR_OUTPUT_FORMAT));
    }

    public boolean isAutoCreateConfigEnabled() {
        return this.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_AUTOCREATE_INITIAL_CONFIGFILE);
    }

    private class ChangeContext {
        private boolean colorChanged = false;
        private boolean validationChanged = false;

        private ChangeContext() {
        }

        private boolean hasChanges() {
            boolean changedAtAll = this.colorChanged;
            changedAtAll = changedAtAll || this.validationChanged;
            return changedAtAll;
        }
    }
}

