/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.preferences;

import de.jcup.asciidoctoreditor.AsciiDoctorEditorActivator;
import de.jcup.asciidoctoreditor.PreviewLayout;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferenceConstants;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.preferences.MultiLineStringFieldEditor;
import de.jcup.asciidoctoreditor.presentation.AccessibleBooleanFieldEditor;
import de.jcup.asciidoctoreditor.presentation.AccessibleDirectoryFieldEditor;
import de.jcup.asciidoctoreditor.presentation.AccessibleFileFieldEditor;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AsciiDoctorEditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected static final int INDENT = 20;
    private ArrayList<MasterButtonSlaveSelectionListener> masterSlaveListeners = new ArrayList();
    private AccessibleDirectoryFieldEditor pathToInstalledAsciidoctor;
    private IntegerFieldEditor aspServerMinPort;
    private IntegerFieldEditor aspServerMaxPort;
    private AccessibleBooleanFieldEditor aspLogRecordsShownAsMarkerInEditor;
    private AccessibleFileFieldEditor pathToJavaForASPlaunch;
    private AccessibleBooleanFieldEditor useInstalledAsciidoctor;
    private Composite baseComposite;
    private AccessibleBooleanFieldEditor aspServerOutputShownInConsole;
    private AccessibleBooleanFieldEditor aspCommunicationShownInConsole;

    protected static void indent(Control control) {
        if (control.getLayoutData() instanceof GridData) {
            ((GridData)control.getLayoutData()).horizontalIndent += 20;
        }
    }

    public AsciiDoctorEditorPreferencePage() {
        super(1);
        this.setPreferenceStore(AsciiDoctorEditorUtil.getPreferences().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        return control;
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        super.performDefaults();
        this.pathToInstalledAsciidoctor.setStringValue("");
        this.masterSlaveListeners.forEach(a -> ((MasterButtonSlaveSelectionListener)a).updateSlaveComponent());
    }

    public boolean performOk() {
        int max;
        int min;
        block4: {
            min = 0;
            max = 0;
            this.setErrorMessage(null);
            this.setValid(true);
            try {
                min = this.aspServerMinPort.getIntValue();
                max = this.aspServerMaxPort.getIntValue();
                if (max > min) break block4;
                this.setErrorMessage("ASP min port must be smaller than max !");
                this.setValid(false);
                return false;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (max - min > 50) {
            this.setErrorMessage("ASP max-min diff must be between 1 and 50!");
            this.setValid(false);
            return false;
        }
        boolean ok = super.performOk();
        AsciiDoctorEditorPreferences.getInstance().setStringPreference(AsciiDoctorEditorPreferenceConstants.P_PATH_TO_INSTALLED_ASCIICDOCTOR, this.pathToInstalledAsciidoctor.getStringValue());
        AsciiDoctorEditorPreferences.getInstance().setStringPreference(AsciiDoctorEditorPreferenceConstants.P_PATH_TO_JAVA_BINARY_FOR_ASP_LAUNCH, this.pathToJavaForASPlaunch.getStringValue());
        AsciiDoctorEditorActivator.getDefault().getAspSupport().configurationChanged();
        return ok;
    }

    protected void createDependency(Button master, Control slave) {
        this.createDependency(master, slave, true, false);
    }

    protected void createDependency(Button master, Control slave, boolean indent) {
        this.createDependency(master, slave, indent, false);
    }

    protected void createDependency(Button master, Control slave, boolean indent, boolean negative) {
        Assert.isNotNull((Object)slave);
        if (indent) {
            AsciiDoctorEditorPreferencePage.indent(slave);
        }
        MasterButtonSlaveSelectionListener listener = new MasterButtonSlaveSelectionListener(master, slave, negative);
        master.addSelectionListener((SelectionListener)listener);
        this.masterSlaveListeners.add(listener);
    }

    protected void createFieldEditors() {
        this.baseComposite = this.createComposite();
        this.createUIGroup(this.baseComposite);
        this.createExternalPreviewParts(this.baseComposite);
        this.createSpacer(this.baseComposite);
        this.createAsciidoctorGroup(this.baseComposite);
        this.createSpacer(this.baseComposite);
        this.createASPGroup(this.baseComposite);
        this.createInstalledAsciidoctorGroup(this.baseComposite);
    }

    public Composite getBaseComposite() {
        return this.baseComposite;
    }

    protected Composite createComposite() {
        Composite composite = new Composite(this.getFieldEditorParent(), 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        return composite;
    }

    protected void createSpacer(Composite composite) {
        Label spacer = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        spacer.setLayoutData((Object)gd);
    }

    protected void createUIGroup(Composite composite) {
        Composite uiComposite = new Composite(composite, 0);
        GridLayout uiLayout = new GridLayout();
        uiLayout.marginWidth = 0;
        uiLayout.marginHeight = 0;
        uiComposite.setLayout((Layout)uiLayout);
        uiComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite devNull = new Composite(uiComposite, 0);
        String[][] entryNamesAndValues = new String[][]{{"Vertical", PreviewLayout.VERTICAL.getId()}, {"Horizontal", PreviewLayout.HORIZONTAL.getId()}, {"Hide preview, use external browser", PreviewLayout.EXTERNAL_BROWSER.getId()}};
        ComboFieldEditor previewDefaultTypeRadioButton = new ComboFieldEditor(AsciiDoctorEditorPreferenceConstants.P_EDITOR_NEWEDITOR_PREVIEW_LAYOUT.getId(), "Default preview layout", entryNamesAndValues, devNull);
        this.addField((FieldEditor)previewDefaultTypeRadioButton);
        devNull = new Composite(uiComposite, 0);
        IntegerFieldEditor tocLevels = new IntegerFieldEditor(AsciiDoctorEditorPreferenceConstants.P_EDITOR_TOC_LEVELS.getId(), "TOC levels shown in preview", devNull);
        tocLevels.setValidRange(0, 7);
        tocLevels.setTextLimit(1);
        tocLevels.getLabelControl(devNull).setToolTipText("0 keeps defaults from asciidoctor, other will set the wanted depth for TOC on preview only!");
        this.addField((FieldEditor)tocLevels);
        devNull = new Composite(uiComposite, 0);
        BooleanFieldEditor autoConfigFileCreationEnabled = new BooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_AUTOCREATE_INITIAL_CONFIGFILE.getId(), "Enable initial config file auto creation", devNull);
        autoConfigFileCreationEnabled.getDescriptionControl(devNull).setToolTipText("When enabled, a .asciidoctorconfig.adoc with description inside \nwill be created in project root folder when no other config file exists.");
        this.addField((FieldEditor)autoConfigFileCreationEnabled);
        devNull = new Composite(uiComposite, 0);
        BooleanFieldEditor linkEditorWithPreviewEnabled = new BooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_LINK_EDITOR_WITH_PREVIEW.getId(), "Link editor with internal preview", devNull);
        linkEditorWithPreviewEnabled.getDescriptionControl(devNull).setToolTipText("When enabled editor caret movements are scrolled in internal preview.\nThis works only in some situations e.g. when cursor moves to a headline");
        this.addField((FieldEditor)linkEditorWithPreviewEnabled);
        BooleanFieldEditor groupOutlineEnabledPerDefault = new BooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_OUTLINE_GROUPING_ENABLED_PER_DEFAULT.getId(), "Show outline grouped per default", devNull);
        groupOutlineEnabledPerDefault.getDescriptionControl(devNull).setToolTipText("This changes default behaviour of editor outline: When enabled outline items are grouped on new opened editor outlines per default.\n\nWhen grouping is turned off the items in outline are ordered by their offset inside document.");
        this.addField((FieldEditor)groupOutlineEnabledPerDefault);
    }

    protected void createExternalPreviewParts(Composite composite) {
        Group externalPreviewGroup = new Group(composite, 0);
        externalPreviewGroup.setText("External preview");
        externalPreviewGroup.setLayout((Layout)new GridLayout());
        externalPreviewGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite devNull1 = new Composite((Composite)externalPreviewGroup, 0);
        AccessibleBooleanFieldEditor autobuildForExternalPreviewEnabled = new AccessibleBooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_EDITOR_AUTOBUILD_FOR_EXTERNAL_PREVIEW_ENABLED.getId(), "Auto build for external preview", devNull1);
        autobuildForExternalPreviewEnabled.getDescriptionControl(devNull1).setToolTipText("When enabled the asciidoctor integration will be called on every change in document. As done in internal previews.\n\nIf disabled only a click to 'refresh' or 'show in external browser' buttons inside the toolbar will rebuild the document.\n\n");
        this.addField((FieldEditor)autobuildForExternalPreviewEnabled);
        Composite devNull2 = new Composite((Composite)externalPreviewGroup, 0);
        IntegerFieldEditor autorefreshSeconds = new IntegerFieldEditor(AsciiDoctorEditorPreferenceConstants.P_EDITOR_AUTOREFRESH_EXTERNAL_BROWSER_IN_SECONDS.getId(), "Auto refresh in external preview (in seconds)", devNull2);
        autorefreshSeconds.setValidRange(0, 30);
        autorefreshSeconds.setTextLimit(2);
        autorefreshSeconds.getLabelControl(devNull2).setToolTipText("0 will turn off auto refresh for external previews.\n\nIf auto build has been disabled, this value will be ignored!");
        this.addField((FieldEditor)autorefreshSeconds);
        this.createDependency(autobuildForExternalPreviewEnabled.getChangeControl(devNull1), (Control)autorefreshSeconds.getTextControl(devNull2));
    }

    protected void checkState() {
        super.checkState();
        if (this.pathToInstalledAsciidoctor != null && !this.pathToInstalledAsciidoctor.checkState()) {
            this.setValid(false);
        }
        if (this.pathToJavaForASPlaunch != null && !this.pathToJavaForASPlaunch.checkState()) {
            this.setValid(false);
        }
    }

    protected void createAsciidoctorGroup(Composite group) {
        this.useInstalledAsciidoctor = new AccessibleBooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_USE_INSTALLED_ASCIIDOCTOR_ENABLED.getId(), "Use installed asciidoctor instead ASP", group);
        this.useInstalledAsciidoctor.getDescriptionControl(group).setToolTipText("When enabled the installed asciidoctor will be used instead of ASP variant.\n\nBe aware about adding correct setup for your CLI arguments in preferences!");
        this.addField((FieldEditor)this.useInstalledAsciidoctor);
    }

    protected void createASPGroup(Composite composite) {
        Group aspGroup = new Group(composite, 0);
        aspGroup.setText("ASP - Asciidoctor server protocol");
        aspGroup.setLayout((Layout)new GridLayout(1, false));
        aspGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Group content = aspGroup;
        Composite serverportComposite = new Composite((Composite)content, 0);
        this.aspServerMinPort = new IntegerFieldEditor(AsciiDoctorEditorPreferenceConstants.P_ASP_SERVER_MIN_PORT.getId(), "ASP Server port range: min", serverportComposite);
        this.aspServerMinPort.getLabelControl(serverportComposite).setToolTipText("Set port range used by ASP server auto port detection - means a free port in given range is detected and used to start new server instance");
        this.aspServerMinPort.getTextControl(serverportComposite).setToolTipText("Set min port for ASP auto port detection");
        this.aspServerMinPort.setValidRange(1000, 65506);
        this.aspServerMinPort.setValidateStrategy(0);
        this.aspServerMaxPort = new IntegerFieldEditor(AsciiDoctorEditorPreferenceConstants.P_ASP_SERVER_MAX_PORT.getId(), "max:", serverportComposite);
        this.aspServerMaxPort.getTextControl(serverportComposite).setToolTipText("Set max port for ASP auto port detection");
        this.aspServerMaxPort.setValidRange(1030, 65536);
        serverportComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        serverportComposite.setLayout((Layout)new GridLayout(5, false));
        Button button = new Button(serverportComposite, 0);
        button.setText("Stop");
        button.setToolTipText("Will stop current running server instance - no \nmatter which port range is set inside this preferences!");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean stopped = AsciiDoctorEditorActivator.getDefault().getAspSupport().stop();
                if (stopped) {
                    MessageDialog.openInformation((Shell)AsciiDoctorEditorPreferencePage.this.getShell(), (String)"ASP server shutdown", (String)"Server has been stopped!");
                } else {
                    MessageDialog.openWarning((Shell)AsciiDoctorEditorPreferencePage.this.getShell(), (String)"ASP server shutdown", (String)"Was not able to shutdown server instance.\nEither this server was not created by this eclipse instance or the process was already stopped");
                }
            }
        });
        this.addField((FieldEditor)this.aspServerMinPort);
        this.addField((FieldEditor)this.aspServerMaxPort);
        this.aspLogRecordsShownAsMarkerInEditor = new AccessibleBooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_ASP_SERVER_LOGS_SHOWN_AS_MARKER_IN_EDITOR.getId(), "ASP log records shown as marker in editor", (Composite)content);
        this.addField((FieldEditor)this.aspLogRecordsShownAsMarkerInEditor);
        this.aspServerOutputShownInConsole = new AccessibleBooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_ASP_SERVER_OUTPUT_SHOWN_IN_CONSOLE.getId(), "ASP server output shown in console", (Composite)content);
        this.addField((FieldEditor)this.aspServerOutputShownInConsole);
        this.aspCommunicationShownInConsole = new AccessibleBooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_ASP_COMMUNICATION_SHOWN_IN_CONSOLE.getId(), "ASP communication shown in console", (Composite)content);
        this.addField((FieldEditor)this.aspCommunicationShownInConsole);
        Composite pathComposite = new Composite((Composite)content, 0);
        this.pathToJavaForASPlaunch = new AccessibleFileFieldEditor(AsciiDoctorEditorPreferenceConstants.P_PATH_TO_JAVA_BINARY_FOR_ASP_LAUNCH.getId(), "Path to Java binary", pathComposite);
        this.pathToJavaForASPlaunch.getTextControl(pathComposite).setMessage("Use installed java");
        this.pathToJavaForASPlaunch.getTextControl(pathComposite).setToolTipText("Full path to another java executable (java/java.exe) which will be called to launch ASP server.\n\nWhen empty, installed java version will be used.");
        this.pathToJavaForASPlaunch.setEmptyStringAllowed(true);
        this.pathToJavaForASPlaunch.setErrorMessage("Invalid path to java executable");
        this.pathToJavaForASPlaunch.getTextControl(pathComposite).addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                AsciiDoctorEditorPreferencePage.this.checkState();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        pathComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        pathComposite.setLayout((Layout)new GridLayout(3, false));
        this.pseudoAddField((FieldEditor)this.pathToJavaForASPlaunch);
        Button changeControl = this.useInstalledAsciidoctor.getChangeControl(this.getBaseComposite());
        this.createDependency(changeControl, (Control)this.aspLogRecordsShownAsMarkerInEditor.getChangeControl((Composite)content), false, true);
        this.createDependency(changeControl, (Control)this.aspServerOutputShownInConsole.getChangeControl((Composite)content), false, true);
        this.createDependency(changeControl, (Control)this.aspCommunicationShownInConsole.getChangeControl((Composite)content), false, true);
        this.createDependency(changeControl, (Control)this.aspServerMinPort.getLabelControl(serverportComposite), false, true);
        this.createDependency(changeControl, (Control)this.aspServerMinPort.getTextControl(serverportComposite), false, true);
        this.createDependency(changeControl, (Control)this.pathToJavaForASPlaunch.getTextControl(pathComposite), false, true);
        this.createDependency(changeControl, (Control)this.pathToJavaForASPlaunch.getLabelControl(pathComposite), false, true);
        this.createDependency(changeControl, (Control)content, false, true);
    }

    protected void createInstalledAsciidoctorGroup(Composite composite) {
        Group installedAsciidoctorGroup = new Group(composite, 0);
        installedAsciidoctorGroup.setText("Installed Asciidoctor");
        installedAsciidoctorGroup.setLayout((Layout)new GridLayout(1, false));
        installedAsciidoctorGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Group content = installedAsciidoctorGroup;
        Composite pathToInstalledComposite = new Composite((Composite)content, 0);
        this.pathToInstalledAsciidoctor = new AccessibleDirectoryFieldEditor(AsciiDoctorEditorPreferenceConstants.P_PATH_TO_INSTALLED_ASCIICDOCTOR.getId(), "Path to Asciidoctor", pathToInstalledComposite);
        this.pathToInstalledAsciidoctor.getTextControl(pathToInstalledComposite).setMessage("Not defined");
        this.pathToInstalledAsciidoctor.getTextControl(pathToInstalledComposite).setToolTipText("If not defined, installed asciidoctor instance must\nbe available from PATH in environment - otherwise it must be a valid directory.");
        this.pathToInstalledAsciidoctor.setEmptyStringAllowed(true);
        this.pathToInstalledAsciidoctor.setErrorMessage("Invalid path to installed Asciidoctor");
        pathToInstalledComposite.setLayout((Layout)new GridLayout(3, false));
        pathToInstalledComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.pseudoAddField((FieldEditor)this.pathToInstalledAsciidoctor);
        this.pathToInstalledAsciidoctor.getTextControl(pathToInstalledComposite).addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                AsciiDoctorEditorPreferencePage.this.checkState();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Composite devNull2 = new Composite((Composite)content, 0);
        MultiLineStringFieldEditor cliArguments = new MultiLineStringFieldEditor(AsciiDoctorEditorPreferenceConstants.P_INSTALLED_ASCIICDOCTOR_ARGUMENTS.getId(), "Custom arguments for Asciidoctor CLI call", devNull2);
        cliArguments.getTextControl().setToolTipText("Setup arguments which shall be added to CLI call of installed asciidoctor instance.\n\nYou can use multiple lines.");
        GridData cliTextLayoutData = new GridData(4, 128, true, false);
        cliArguments.getTextControl().setLayoutData((Object)cliTextLayoutData);
        devNull2.setLayoutData((Object)new GridData(4, 128, true, false));
        devNull2.setLayout((Layout)new GridLayout());
        this.addField(cliArguments);
        Composite devNull3 = new Composite((Composite)content, 0);
        AccessibleBooleanFieldEditor consoleEnabled = new AccessibleBooleanFieldEditor(AsciiDoctorEditorPreferenceConstants.P_SHOW_ASCIIDOC_CONSOLE_ON_ERROR_OUTPUT.getId(), "Show console when asciidoctor writes to standard error", devNull3);
        this.addField((FieldEditor)consoleEnabled);
        Button changeControl = this.useInstalledAsciidoctor.getChangeControl(this.getBaseComposite());
        this.createDependency(changeControl, (Control)this.pathToInstalledAsciidoctor.getTextControl(pathToInstalledComposite), false);
        this.createDependency(changeControl, (Control)this.pathToInstalledAsciidoctor.getLabelControl(pathToInstalledComposite), false);
        this.createDependency(changeControl, (Control)this.pathToInstalledAsciidoctor.getChangeControl(pathToInstalledComposite), false);
        this.createDependency(changeControl, (Control)cliArguments.getTextControl(devNull2), false);
        this.createDependency(changeControl, (Control)cliArguments.getLabelControl(devNull2), false);
        this.createDependency(changeControl, (Control)consoleEnabled.getChangeControl(devNull3), false);
        this.createDependency(changeControl, (Control)content, false);
    }

    private void pseudoAddField(FieldEditor pe) {
        pe.setPage((DialogPage)this);
        pe.setPropertyChangeListener((IPropertyChangeListener)this);
        pe.setPreferenceStore(this.getPreferenceStore());
        pe.load();
    }

    protected void initialize() {
        super.initialize();
        this.updateSlaveComponents();
    }

    protected Button addButton(Composite parent, int style, String label, int indentation, SelectionListener listener) {
        Button button = new Button(parent, style);
        button.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        button.addSelectionListener(listener);
        return button;
    }

    void setBoolean(AsciiDoctorEditorPreferenceConstants id, boolean value) {
        AsciiDoctorEditorUtil.getPreferences().setBooleanPreference(id, value);
    }

    boolean getBoolean(AsciiDoctorEditorPreferenceConstants id) {
        return AsciiDoctorEditorUtil.getPreferences().getBooleanPreference(id);
    }

    boolean getDefaultBoolean(AsciiDoctorEditorPreferenceConstants id) {
        return AsciiDoctorEditorUtil.getPreferences().getDefaultBooleanPreference(id);
    }

    private void updateSlaveComponents() {
        for (MasterButtonSlaveSelectionListener listener : this.masterSlaveListeners) {
            listener.updateSlaveComponent();
        }
    }

    private class MasterButtonSlaveSelectionListener
    implements SelectionListener {
        private Button master;
        private Control slave;
        private boolean negative;

        public MasterButtonSlaveSelectionListener(Button master, Control slave, boolean negative) {
            this.master = master;
            this.slave = slave;
            this.negative = negative;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateSlaveComponent();
        }

        private void updateSlaveComponent() {
            boolean state = this.master.getSelection();
            if (this.negative) {
                this.slave.setEnabled(!state);
            } else {
                this.slave.setEnabled(state);
            }
        }
    }
}

