/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.outline;

import de.jcup.asciidoctoreditor.outline.ItemType;
import java.util.ArrayList;
import java.util.List;

public class Item
implements Comparable<Item> {
    ItemType type;
    String name;
    int offset;
    int length;
    int endOffset;
    String prefix;
    String filePath;
    List<Item> children = new ArrayList<Item>();
    Item parent;
    String fullString;
    String id;

    public List<Item> getChildren() {
        return this.children;
    }

    public Item getParent() {
        return this.parent;
    }

    public String getFilePathOrNull() {
        return this.filePath;
    }

    public ItemType getItemType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Item:");
        sb.append("label:");
        sb.append(this.name);
        sb.append(",blockType:");
        sb.append((Object)this.type);
        sb.append(",offset:");
        sb.append(this.offset);
        sb.append(",length:");
        sb.append(this.length);
        sb.append(",endOffset:");
        sb.append(this.endOffset);
        sb.append(",filePath:");
        sb.append(this.filePath);
        return sb.toString();
    }

    public String buildSearchString() {
        return this.name;
    }

    public String getFullString() {
        return this.fullString == null ? this.name : this.fullString;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public int compareTo(Item o) {
        if (o == null) {
            return -1;
        }
        return this.getOffset() - o.getOffset();
    }
}

