/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.outline;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.AsciiDoctorEditorActivator;
import de.jcup.asciidoctoreditor.FilterPatternMatcher;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorContentOutlinePage;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorEditorOutlineLabelProvider;
import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.outline.ItemTextMatcher;
import de.jcup.asciidoctoreditor.outline.ItemTextViewerFilter;
import de.jcup.asciidoctoreditor.ui.AbstractFilterableTreeQuickDialog;
import de.jcup.asciidoctoreditor.ui.AbstractTreeViewerFilter;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AsciiDoctorQuickOutlineDialog
extends AbstractFilterableTreeQuickDialog<Item> {
    private static final int MIN_WIDTH = 400;
    private static final int MIN_HEIGHT = 300;
    private AsciiDoctorEditor editor;

    public AsciiDoctorQuickOutlineDialog(IAdaptable adaptable, Shell parent, String infoText) {
        super(adaptable, parent, "AsciiDoctorWrapper quick outline", 400, 300, infoText);
        this.editor = (AsciiDoctorEditor)adaptable.getAdapter(AsciiDoctorEditor.class);
    }

    @Override
    protected ITreeContentProvider createTreeContentProvider(IAdaptable adaptable) {
        return (ITreeContentProvider)adaptable.getAdapter(ITreeContentProvider.class);
    }

    @Override
    protected void openSelectionImpl(ISelection selection, String filterText) {
        if (this.editor == null) {
            return;
        }
        AsciiDoctorContentOutlinePage outlinePage = this.editor.getOutlineSupport().getOutlinePage();
        boolean outlineAvailable = this.outlinePageVisible(outlinePage);
        if (outlineAvailable) {
            this.editor.getOutlineSupport().openSelectedTreeItemInEditor(selection, false);
        } else {
            outlinePage.setSelection(selection);
        }
    }

    protected boolean outlinePageVisible(AsciiDoctorContentOutlinePage outlinePage) {
        Control control = outlinePage.getControl();
        boolean controlAvailable = control == null || control.isDisposed() || !control.isVisible();
        return controlAvailable;
    }

    @Override
    protected AbstractUIPlugin getUIPlugin() {
        AsciiDoctorEditorActivator editorActivator = AsciiDoctorEditorActivator.getDefault();
        return editorActivator;
    }

    @Override
    protected Item getInitialSelectedItem() {
        if (this.editor == null) {
            return null;
        }
        Item item = this.editor.getItemAtCarretPosition();
        return item;
    }

    @Override
    protected FilterPatternMatcher<Item> createItemMatcher() {
        return new ItemTextMatcher();
    }

    @Override
    protected IBaseLabelProvider createLabelProvider() {
        AsciiDoctorEditorOutlineLabelProvider labelProvider = new AsciiDoctorEditorOutlineLabelProvider();
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider);
    }

    @Override
    protected AbstractTreeViewerFilter<Item> createFilter() {
        return new ItemTextViewerFilter();
    }
}

