/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.outline;

import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.outline.ItemType;
import de.jcup.asciidoctoreditor.script.AsciiDoctorFileReference;
import de.jcup.asciidoctoreditor.script.AsciiDoctorHeadline;
import de.jcup.asciidoctoreditor.script.AsciiDoctorInlineAnchor;
import de.jcup.asciidoctoreditor.script.AsciiDoctorScriptModel;
import de.jcup.asciidoctoreditor.script.parser.ParseToken;
import de.jcup.eclipse.commons.SimpleStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class AsciiDoctorEditorTreeContentProvider
implements ITreeContentProvider {
    private static final String ASCIIDOCTOR_SCRIPT_CONTAINS_ERRORS = "AsciiDoctorWrapper script contains errors.";
    private static final String ASCIIDOCTOR_SCRIPT_DOES_NOT_CONTAIN_OUTLINE_PARTS = "Your document has no includes or headlines";
    private static final Object[] RESULT_WHEN_EMPTY = new Object[]{"Your document has no includes or headlines"};
    private Object[] items;
    private Item cachedLastFoundItemByOffset;
    private Object monitor = new Object();
    private boolean groupingEnabled = true;

    AsciiDoctorEditorTreeContentProvider() {
        this.items = RESULT_WHEN_EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object inputElement) {
        Object object = this.monitor;
        synchronized (object) {
            if (inputElement != null && !(inputElement instanceof AsciiDoctorScriptModel)) {
                return new Object[]{"Unsupported input element:" + inputElement};
            }
            if (this.items != null && this.items.length > 0) {
                return this.items;
            }
        }
        return RESULT_WHEN_EMPTY;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Item) {
            Item item = (Item)parentElement;
            return item.getChildren().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof Item) {
            Item item = (Item)element;
            return item.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Item) {
            Item item = (Item)element;
            return !item.getChildren().isEmpty();
        }
        return false;
    }

    private Item[] createItems(AsciiDoctorScriptModel model) {
        Item item;
        HashMap<Integer, Item> parents = new HashMap<Integer, Item>();
        ArrayList<Item> list = new ArrayList<Item>();
        this.addHeadlines(model, parents, list);
        this.addAnchors(model, list);
        this.addIncludes(model, list);
        if (list.isEmpty()) {
            item = new Item();
            item.name = ASCIIDOCTOR_SCRIPT_DOES_NOT_CONTAIN_OUTLINE_PARTS;
            item.type = ItemType.META_INFO;
            item.offset = 0;
            item.length = 0;
            item.endOffset = 0;
            list.add(item);
        }
        if (!this.groupingEnabled) {
            this.ungroup(parents, list);
        }
        if (model.hasDebugTokens()) {
            if (model.hasErrors()) {
                item = new Item();
                item.name = ASCIIDOCTOR_SCRIPT_CONTAINS_ERRORS;
                item.type = ItemType.META_ERROR;
                item.offset = 0;
                item.length = 0;
                item.endOffset = 0;
                list.add(0, item);
            }
            for (ParseToken token : model.getDebugTokens()) {
                Item item2 = new Item();
                item2.name = String.valueOf(SimpleStringUtils.shortString((String)token.getText(), (int)40)) + " :<- " + token.createTypeDescription();
                item2.type = ItemType.META_DEBUG;
                item2.offset = token.getStart();
                item2.length = token.getText().length();
                item2.endOffset = token.getEnd();
                list.add(item2);
            }
        }
        return list.toArray(new Item[list.size()]);
    }

    private void ungroup(Map<Integer, Item> parents, List<Item> list) {
        ArrayList<Item> itemsToMoveInHeadlineTree = new ArrayList<Item>(list);
        ArrayList<Item> headlineFlatList = new ArrayList<Item>();
        for (Item parent : parents.values()) {
            this.findFlatHeadlineParts(parent, headlineFlatList);
        }
        for (Item item : list) {
            if (item.type != ItemType.HEADLINE || headlineFlatList.contains(item)) continue;
            headlineFlatList.add(item);
        }
        itemsToMoveInHeadlineTree.removeAll(headlineFlatList);
        for (Item itemToMove : itemsToMoveInHeadlineTree) {
            if (itemToMove.getItemType() == ItemType.HEADLINE) continue;
            Item targetParent = null;
            int targetOffsetDiff = Integer.MAX_VALUE;
            for (Item parent : headlineFlatList) {
                int newDiff = itemToMove.getOffset() - parent.getOffset();
                if (newDiff <= 0 || newDiff >= targetOffsetDiff) continue;
                targetParent = parent;
                targetOffsetDiff = newDiff;
            }
            if (targetParent == null) continue;
            list.remove(itemToMove);
            List<Item> childList = targetParent.getChildren();
            childList.add(itemToMove);
        }
        for (Item parent : headlineFlatList) {
            List<Item> childList = parent.getChildren();
            Collections.sort(childList);
        }
        Collections.sort(list);
    }

    private void findFlatHeadlineParts(Item parent, List<Item> list) {
        if (parent == null || parent.getItemType() != ItemType.HEADLINE) {
            return;
        }
        List<Item> children = parent.getChildren();
        list.addAll(children);
        for (Item child : children) {
            this.findFlatHeadlineParts(child, list);
        }
    }

    protected void addIncludes(AsciiDoctorScriptModel model, List<Item> list) {
        for (AsciiDoctorFileReference include : model.getIncludes()) {
            Item item = new Item();
            item.name = include.getLabel();
            item.type = ItemType.INCLUDE;
            item.offset = include.getPosition();
            item.length = include.getLengthToNameEnd();
            item.endOffset = include.getEnd();
            item.fullString = include.getFullExpression();
            item.filePath = include.getFilePath();
            list.add(item);
        }
    }

    protected void addHeadlines(AsciiDoctorScriptModel model, Map<Integer, Item> parents, List<Item> list) {
        boolean alreadyOneDeep1 = false;
        for (AsciiDoctorHeadline headline : model.getHeadlines()) {
            Item item = new Item();
            item.name = headline.getName();
            int originDeep = headline.getDeep();
            if (!alreadyOneDeep1 && originDeep == 1) {
                alreadyOneDeep1 = true;
            } else {
                item.id = headline.getId();
            }
            int deep = originDeep - 1;
            item.prefix = "H" + deep + ":";
            item.type = ItemType.HEADLINE;
            item.offset = headline.getPosition();
            item.length = headline.getLengthToNameEnd();
            item.endOffset = headline.getEnd();
            parents.put(deep, item);
            Item parent = parents.get(deep - 1);
            if (parent == null) {
                list.add(item);
                continue;
            }
            parent.getChildren().add(item);
            item.parent = parent;
        }
    }

    protected void addAnchors(AsciiDoctorScriptModel model, List<Item> list) {
        for (AsciiDoctorInlineAnchor anchor : model.getInlineAnchors()) {
            Item item = new Item();
            item.name = anchor.getId();
            item.id = anchor.getId();
            item.prefix = "";
            item.type = ItemType.INLINE_ANCHOR;
            item.offset = anchor.getPosition();
            item.length = anchor.getLabel().length();
            item.endOffset = anchor.getEnd();
            list.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildTree(AsciiDoctorScriptModel model) {
        Object object = this.monitor;
        synchronized (object) {
            if (model == null) {
                this.items = null;
                this.cachedLastFoundItemByOffset = null;
                return;
            }
            this.items = this.createItems(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item tryToFindByOffset(int offset) {
        Object object = this.monitor;
        synchronized (object) {
            block7: {
                if (this.items != null) break block7;
                return null;
            }
            if (this.cachedLastFoundItemByOffset != null && this.cachedLastFoundItemByOffset.offset == offset) {
                return this.cachedLastFoundItemByOffset;
            }
            this.cachedLastFoundItemByOffset = null;
            ArrayList<Item> list = new ArrayList<Item>();
            Object[] objectArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                Object oItem = objectArray[n2];
                if (oItem instanceof Item) {
                    list.add((Item)oItem);
                }
                ++n2;
            }
            this.inspectUntilNextCachedItem(offset, list);
            return this.cachedLastFoundItemByOffset;
        }
    }

    protected void inspectUntilNextCachedItem(int offset, List<Item> itemsToSearch) {
        if (this.cachedLastFoundItemByOffset != null) {
            return;
        }
        for (Item item : itemsToSearch) {
            int itemStart = item.getOffset();
            int itemEnd = item.getEndOffset();
            if (offset >= itemStart && offset <= itemEnd) {
                this.cachedLastFoundItemByOffset = item;
                return;
            }
            this.inspectUntilNextCachedItem(offset, item.getChildren());
        }
    }

    public void setGroupingEnabled(boolean groupingEnabled) {
        this.groupingEnabled = groupingEnabled;
    }

    public boolean isGroupingEnabled() {
        return this.groupingEnabled;
    }
}

