/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.outline;

import de.jcup.asciidoctoreditor.AsciiDoctorEditorActivator;
import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.outline.ItemType;
import de.jcup.asciidoctoreditor.ui.AsciiDoctorEditorColorConstants;
import de.jcup.asciidoctoreditor.ui.AsciidoctorIconConstants;
import de.jcup.asciidoctoreditor.ui.ColorManager;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;

public class AsciiDoctorEditorOutlineLabelProvider
extends BaseLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IColorProvider {
    private StyledString.Styler outlineItemTypeStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = AsciiDoctorEditorOutlineLabelProvider.this.getColorManager().getColor(AsciiDoctorEditorColorConstants.OUTLINE_ITEM__TYPE);
        }
    };

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Item) {
            Item item = (Item)element;
            ItemType type = item.getItemType();
            if (type == null) {
                return null;
            }
            switch (type) {
                case HEADLINE: {
                    return AsciiDoctorEditorOutlineLabelProvider.getImage(AsciidoctorIconConstants.PATH_OUTLINE_ICON_HEADLINE);
                }
                case INLINE_ANCHOR: {
                    return AsciiDoctorEditorOutlineLabelProvider.getImage(AsciidoctorIconConstants.PATH_OUTLINE_ICON_INLINE_ANCHOR);
                }
                case INCLUDE: {
                    return AsciiDoctorEditorOutlineLabelProvider.getImage(AsciidoctorIconConstants.PATH_OUTLINE_ICON_INCLUDE);
                }
                case META_ERROR: {
                    return AsciiDoctorEditorOutlineLabelProvider.getImage(AsciidoctorIconConstants.PATH_OUTLINE_ICON_ERROR);
                }
                case META_INFO: {
                    return AsciiDoctorEditorOutlineLabelProvider.getImage(AsciidoctorIconConstants.PATH_OUTLINE_ICON_INFO);
                }
            }
            return null;
        }
        return null;
    }

    public StyledString getStyledText(Object element) {
        StyledString styled = new StyledString();
        if (element == null) {
            styled.append("null");
        }
        if (element instanceof Item) {
            StyledString typeString;
            Item item = (Item)element;
            ItemType itemType = item.getItemType();
            if (itemType == ItemType.HEADLINE) {
                typeString = new StyledString(item.getPrefix(), this.outlineItemTypeStyler);
                styled.append(typeString);
            } else if (itemType == ItemType.META_DEBUG) {
                typeString = new StyledString(String.valueOf(item.getOffset()) + ": ", this.outlineItemTypeStyler);
                styled.append(typeString);
            }
            String name = item.getName();
            if (name != null) {
                styled.append(name);
            }
        } else {
            return styled.append(element.toString());
        }
        return styled;
    }

    public ColorManager getColorManager() {
        AsciiDoctorEditorActivator editorActivator = AsciiDoctorEditorActivator.getDefault();
        if (editorActivator == null) {
            return ColorManager.getStandalone();
        }
        return editorActivator.getColorManager();
    }

    public static final Image getImage(String path) {
        return EclipseUtil.getImage(path, "de.jcup.asciidoctoreditor");
    }
}

