/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.outline;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocStringUtils;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorEditorOutlineLabelProvider;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorEditorTreeContentProvider;
import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.outline.ItemType;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.script.AsciiDoctorScriptModel;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class AsciiDoctorContentOutlinePage
extends ContentOutlinePage
implements IDoubleClickListener {
    private static final ImageDescriptor IMG_DESC_GROUPED = AsciiDoctorContentOutlinePage.createOutlineImageDescriptor("grouped.png");
    private static final ImageDescriptor IMG_DESC_NOT_GROUPED = AsciiDoctorContentOutlinePage.createOutlineImageDescriptor("not_grouped.png");
    private static final ImageDescriptor IMG_DESC_LINKED = AsciiDoctorContentOutlinePage.createOutlineImageDescriptor("synced.png");
    private static final ImageDescriptor IMG_DESC_NOT_LINKED = AsciiDoctorContentOutlinePage.createOutlineImageDescriptor("sync_broken.png");
    private static final ImageDescriptor IMG_DESC_EXPAND_ALL = AsciiDoctorContentOutlinePage.createOutlineImageDescriptor("expandall.png");
    private static final ImageDescriptor IMG_DESC_COLLAPSE_ALL = AsciiDoctorContentOutlinePage.createOutlineImageDescriptor("collapseall.png");
    private AsciiDoctorEditorTreeContentProvider contentProvider;
    private Object input;
    private AsciiDoctorEditor editor;
    private AsciiDoctorEditorOutlineLabelProvider labelProvider;
    private boolean linkingWithEditorEnabled;
    private boolean ignoreNextSelectionEvents;
    private ToggleLinkingAction toggleLinkingAction;

    public AsciiDoctorContentOutlinePage(AsciiDoctorEditor editor) {
        this.editor = editor;
        this.contentProvider = new AsciiDoctorEditorTreeContentProvider();
        this.contentProvider.setGroupingEnabled(AsciiDoctorEditorPreferences.getInstance().isGroupingInOutlineEnabledPerDefault());
    }

    public AsciiDoctorEditorTreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.labelProvider = new AsciiDoctorEditorOutlineLabelProvider();
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.addDoubleClickListener((IDoubleClickListener)this);
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.labelProvider));
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.input != null) {
            viewer.setInput(this.input);
        }
        this.toggleLinkingAction = new ToggleLinkingAction();
        this.toggleLinkingAction.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new ExpandAllAction());
        toolBarManager.add((IAction)new CollapseAllAction());
        toolBarManager.add((IAction)this.toggleLinkingAction);
        toolBarManager.add((IAction)new ToggleSortAction());
        IMenuManager viewMenuManager = actionBars.getMenuManager();
        viewMenuManager.add((IContributionItem)new Separator("EndFilterGroup"));
        viewMenuManager.add((IContributionItem)new Separator("treeGroup"));
        viewMenuManager.add((IAction)this.toggleLinkingAction);
        if (this.input == null && this.editor != null) {
            this.editor.getOutlineSupport().rebuildOutlineAndValidate();
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.editor == null) {
            return;
        }
        ISelection selection = event.getSelection();
        if (this.isAnIncludedAndHandled(selection)) {
            return;
        }
        if (this.linkingWithEditorEnabled) {
            this.editor.setFocus();
            return;
        }
        this.editor.getOutlineSupport().openSelectedTreeItemInEditor(selection, true);
    }

    private boolean isAnIncludedAndHandled(ISelection selection) {
        IStructuredSelection ss;
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof Item) {
            Item item = (Item)firstElement;
            ItemType type = item.getItemType();
            if (type != ItemType.INCLUDE) {
                return false;
            }
            String fullString = item.getFullString();
            String fileName = AsciiDocStringUtils.resolveFilenameOfIncludeOrNull(fullString);
            if (fileName != null) {
                this.editor.openInclude(fileName);
                return true;
            }
        }
        return false;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        if (!this.linkingWithEditorEnabled) {
            return;
        }
        if (this.ignoreNextSelectionEvents) {
            return;
        }
        ISelection selection = event.getSelection();
        this.editor.getOutlineSupport().openSelectedTreeItemInEditor(selection, false);
    }

    public void onEditorCaretMoved(int caretOffset) {
        AsciiDoctorEditorTreeContentProvider provider;
        Item item;
        if (!this.linkingWithEditorEnabled) {
            return;
        }
        this.ignoreNextSelectionEvents = true;
        if (this.contentProvider instanceof AsciiDoctorEditorTreeContentProvider && (item = (provider = this.contentProvider).tryToFindByOffset(caretOffset)) != null) {
            StructuredSelection selection = new StructuredSelection((Object)item);
            this.getTreeViewer().setSelection((ISelection)selection, true);
        }
        this.ignoreNextSelectionEvents = false;
    }

    public void rebuild(AsciiDoctorScriptModel model) {
        if (model == null) {
            return;
        }
        this.contentProvider.rebuildTree(model);
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            Control control = treeViewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            treeViewer.setInput((Object)model);
            treeViewer.expandAll();
        }
    }

    protected ImageDescriptor getImageDescriptionForLinked() {
        return IMG_DESC_LINKED;
    }

    protected ImageDescriptor getImageDescriptionNotLinked() {
        return IMG_DESC_NOT_LINKED;
    }

    protected ImageDescriptor getImageDescriptionForGrouped() {
        return IMG_DESC_GROUPED;
    }

    protected ImageDescriptor getImageDescriptionNotGrouped() {
        return IMG_DESC_NOT_GROUPED;
    }

    private static ImageDescriptor createOutlineImageDescriptor(String name) {
        return EclipseUtil.createImageDescriptor("/icons/outline/" + name, "de.jcup.asciidoctoreditor");
    }

    class CollapseAllAction
    extends Action {
        private CollapseAllAction() {
            this.setImageDescriptor(IMG_DESC_COLLAPSE_ALL);
            this.setText("Collapse all");
        }

        public void run() {
            AsciiDoctorContentOutlinePage.this.getTreeViewer().collapseAll();
        }
    }

    class ExpandAllAction
    extends Action {
        private ExpandAllAction() {
            this.setImageDescriptor(IMG_DESC_EXPAND_ALL);
            this.setText("Expand all");
        }

        public void run() {
            AsciiDoctorContentOutlinePage.this.getTreeViewer().expandAll();
        }
    }

    class ToggleLinkingAction
    extends Action {
        private ToggleLinkingAction() {
            if (AsciiDoctorContentOutlinePage.this.editor != null) {
                AsciiDoctorContentOutlinePage.this.linkingWithEditorEnabled = AsciiDoctorContentOutlinePage.this.editor.getPreferences().isLinkOutlineWithEditorEnabled();
            }
            this.setDescription("link with editor");
            this.initImage();
            this.initText();
        }

        public void run() {
            AsciiDoctorContentOutlinePage.this.linkingWithEditorEnabled = !AsciiDoctorContentOutlinePage.this.linkingWithEditorEnabled;
            this.initText();
            this.initImage();
        }

        private void initImage() {
            this.setImageDescriptor(AsciiDoctorContentOutlinePage.this.linkingWithEditorEnabled ? AsciiDoctorContentOutlinePage.this.getImageDescriptionForLinked() : AsciiDoctorContentOutlinePage.this.getImageDescriptionNotLinked());
        }

        private void initText() {
            this.setText(AsciiDoctorContentOutlinePage.this.linkingWithEditorEnabled ? "Click to unlink from editor" : "Click to link with editor");
        }
    }

    class ToggleSortAction
    extends Action {
        private ToggleSortAction() {
            if (AsciiDoctorContentOutlinePage.this.editor != null) {
                AsciiDoctorContentOutlinePage.this.linkingWithEditorEnabled = AsciiDoctorContentOutlinePage.this.editor.getPreferences().isLinkOutlineWithEditorEnabled();
            }
            this.setDescription("link with editor");
            this.initImage();
            this.initText();
        }

        public void run() {
            AsciiDoctorContentOutlinePage.this.contentProvider.setGroupingEnabled(!AsciiDoctorContentOutlinePage.this.contentProvider.isGroupingEnabled());
            this.initText();
            this.initImage();
            if (AsciiDoctorContentOutlinePage.this.editor == null) {
                return;
            }
            AsciiDoctorContentOutlinePage.this.editor.rebuildOutlineAndValidate();
        }

        private void initImage() {
            this.setImageDescriptor(AsciiDoctorContentOutlinePage.this.contentProvider.isGroupingEnabled() ? AsciiDoctorContentOutlinePage.this.getImageDescriptionForGrouped() : AsciiDoctorContentOutlinePage.this.getImageDescriptionNotGrouped());
        }

        private void initText() {
            this.setText(AsciiDoctorContentOutlinePage.this.contentProvider.isGroupingEnabled() ? "Click to disable grouping" : "Click to enable grouping");
        }
    }
}

