/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.hyperlink;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocStringUtils;
import de.jcup.asciidoctoreditor.hyperlink.AsciiDoctorEditorHeadlineHyperlink;
import de.jcup.asciidoctoreditor.hyperlink.AsciiDoctorEditorOpenDiagramHyperlink;
import de.jcup.asciidoctoreditor.hyperlink.AsciiDoctorEditorOpenImageHyperlink;
import de.jcup.asciidoctoreditor.hyperlink.AsciiDoctorEditorOpenIncludeHyperlink;
import de.jcup.asciidoctoreditor.script.AsciiDoctorHeadline;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class AsciiDoctorEditorLinkTextHyperlinkDetector
extends AbstractHyperlinkDetector {
    private IAdaptable adaptable;

    public AsciiDoctorEditorLinkTextHyperlinkDetector(IAdaptable editor) {
        this.adaptable = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (this.adaptable == null) {
            return null;
        }
        AsciiDoctorEditor editor = (AsciiDoctorEditor)this.adaptable.getAdapter(AsciiDoctorEditor.class);
        if (editor == null) {
            return null;
        }
        return this.resolveHyperlinks(textViewer, region, editor);
    }

    public IHyperlink[] resolveHyperlinks(ITextViewer textViewer, IRegion region, AsciiDoctorEditor editor) {
        String line;
        IRegion lineInfo;
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        int offsetInLine = offset - lineInfo.getOffset();
        AsciiDocStringUtils.LinkTextData linkTextData = AsciiDocStringUtils.resolveTextFromStartToBracketsEnd(line, offset, offsetInLine);
        ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
        this.append(hyperlinks, this.resolveLinkToInclude(linkTextData, editor));
        this.append(hyperlinks, this.resolveLinkToImage(linkTextData, editor));
        this.append(hyperlinks, this.resolveLinkToHeadline(linkTextData, editor));
        this.append(hyperlinks, this.resolveLinkToDiagram(linkTextData, editor));
        if (hyperlinks.isEmpty()) {
            return null;
        }
        return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
    }

    private Region createTargetRegion(AsciiDocStringUtils.LinkTextData linkTextData) {
        Region targetRegion = new Region(linkTextData.offsetLeft, linkTextData.text.length());
        return targetRegion;
    }

    private void append(List<IHyperlink> hyperlinks, IHyperlink[] hyperlinkArray) {
        if (hyperlinkArray == null) {
            return;
        }
        IHyperlink[] iHyperlinkArray = hyperlinkArray;
        int n = hyperlinkArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlink hyperlink = iHyperlinkArray[n2];
            if (hyperlink != null) {
                hyperlinks.add(hyperlink);
            }
            ++n2;
        }
    }

    private IHyperlink[] resolveLinkToImage(AsciiDocStringUtils.LinkTextData linkTextData, AsciiDoctorEditor editor) {
        String imageName = AsciiDocStringUtils.resolveFilenameOfImageOrNull(linkTextData.text);
        if (imageName != null) {
            Region targetRegion = this.createTargetRegion(linkTextData);
            return new IHyperlink[]{new AsciiDoctorEditorOpenImageHyperlink((IRegion)targetRegion, imageName, editor)};
        }
        return null;
    }

    private IHyperlink[] resolveLinkToHeadline(AsciiDocStringUtils.LinkTextData linkTextData, AsciiDoctorEditor editor) {
        String foundText = linkTextData.text;
        AsciiDoctorHeadline headline = editor.findAsciiDoctorHeadlineByName(foundText);
        if (headline != null) {
            Region targetRegion = this.createTargetRegion(linkTextData);
            return new IHyperlink[]{new AsciiDoctorEditorHeadlineHyperlink((IRegion)targetRegion, headline, editor)};
        }
        return null;
    }

    protected IHyperlink[] resolveLinkToInclude(AsciiDocStringUtils.LinkTextData linkTextData, AsciiDoctorEditor editor) {
        String foundText = linkTextData.text;
        String includeFileName = AsciiDocStringUtils.resolveFilenameOfIncludeOrNull(foundText);
        if (includeFileName != null) {
            Region targetRegion = this.createTargetRegion(linkTextData);
            return new IHyperlink[]{new AsciiDoctorEditorOpenIncludeHyperlink((IRegion)targetRegion, includeFileName, editor)};
        }
        return null;
    }

    protected IHyperlink[] resolveLinkToDiagram(AsciiDocStringUtils.LinkTextData linkTextData, AsciiDoctorEditor editor) {
        String foundText = linkTextData.text;
        String diagramFileName = AsciiDocStringUtils.resolveFilenameOfDiagramMacroOrNull(foundText);
        if (diagramFileName != null) {
            Region targetRegion = this.createTargetRegion(linkTextData);
            return new IHyperlink[]{new AsciiDoctorEditorOpenDiagramHyperlink((IRegion)targetRegion, diagramFileName, editor)};
        }
        return null;
    }
}

