/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.handlers;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorWrapper;
import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.outline.ItemType;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorProviderContext;
import de.jcup.asciidoctoreditor.search.FindAsciidocfileReferencesQuery;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.eclipse.commons.EclipseResourceHelper;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ReferencesWorkspaceHandler
extends AbstractHandler {
    private static final Object NO_RESULT = null;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.internalExecute(event);
        return NO_RESULT;
    }

    private void internalExecute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.handleSelectionAction(selection);
            return;
        }
        if (!(selection instanceof ITextSelection)) {
            this.handleEditorAction();
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        String text = textSelection.getText();
        if (text == null || text.trim().isEmpty()) {
            this.handleEditorAction();
            return;
        }
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof AsciiDoctorEditor)) {
            return;
        }
        AsciiDoctorEditor asciidocEditor = (AsciiDoctorEditor)editor;
        Item found = asciidocEditor.getOutlineSupport().getOutlinePage().getContentProvider().tryToFindByOffset(((ITextSelection)selection).getOffset());
        if (found == null) {
            return;
        }
        if (ItemType.INCLUDE.equals((Object)found.getItemType())) {
            this.handleInclude(asciidocEditor, found);
            return;
        }
    }

    private void handleInclude(AsciiDoctorEditor editor, Item found) throws ExecutionException {
        String filePath = found.getFilePathOrNull();
        if (filePath == null) {
            return;
        }
        AsciiDoctorWrapper wrapper = editor.getWrapper();
        if (wrapper == null) {
            return;
        }
        AsciiDoctorProviderContext context = wrapper.getContext();
        if (context == null) {
            return;
        }
        File baseDir = context.getBaseDir();
        if (baseDir == null) {
            return;
        }
        File file = new File(baseDir, filePath);
        this.triggerSearchFor(file);
    }

    private void handleEditorAction() throws ExecutionException {
        AsciiDoctorEditor editor = AsciiDoctorEditorUtil.findActiveAsciidoctorEditorOrNull();
        if (editor == null) {
            return;
        }
        File editorFile = editor.getEditorFileOrNull();
        this.triggerSearchFor(editorFile);
    }

    private void handleSelectionAction(ISelection selection) throws ExecutionException {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        Object first = ssel.getFirstElement();
        if (first instanceof IFile) {
            IFile file = (IFile)first;
            try {
                this.triggerSearchFor(EclipseResourceHelper.DEFAULT.toFile((IResource)file));
            }
            catch (CoreException e) {
                throw new ExecutionException("Was not able to search for selectedFile:" + file, (Throwable)e);
            }
        }
    }

    private void triggerSearchFor(File editorFile) {
        if (editorFile == null) {
            return;
        }
        NewSearchUI.runQueryInBackground((ISearchQuery)new FindAsciidocfileReferencesQuery(editorFile));
    }
}

