/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.document;

import de.jcup.asciidoctoreditor.EndlessLoopPreventer;
import de.jcup.asciidoctoreditor.document.PlainJavaCharacterScanner;

public class FormattedTextFinder {
    private static final int MAX_LOOPS = 10000;
    private char[] starting;
    private char[] ending;
    private static boolean TRACE_MODE = Boolean.getBoolean("de.jcup.trace.formattedtextfinder");

    public FormattedTextFinder(String start, String end) {
        this.starting = start.toCharArray();
        this.ending = end.toCharArray();
    }

    public boolean isFound(PlainJavaCharacterScanner adapter) {
        boolean isFound;
        if (TRACE_MODE) {
            adapter.startTracing();
        }
        if (!(isFound = this.find(adapter))) {
            adapter.rewind();
        }
        return isFound;
    }

    private boolean find(PlainJavaCharacterScanner scanner) {
        if (scanner.getColumn() > 0) {
            boolean acceptableBefore;
            scanner.unread();
            int before = scanner.read();
            boolean bl = acceptableBefore = !Character.isAlphabetic(before);
            if (!acceptableBefore) {
                return false;
            }
        }
        return this.findFromValidTextBefore(scanner);
    }

    private boolean findFromValidTextBefore(PlainJavaCharacterScanner scanner) {
        int read = scanner.read();
        if (this.isEOF(read) || this.isLineBreak(read, scanner)) {
            return false;
        }
        char[] cArray = this.starting;
        int n = this.starting.length;
        int n2 = 0;
        while (n2 < n) {
            char s = cArray[n2];
            if (s != read) {
                return false;
            }
            read = scanner.read();
            ++n2;
        }
        if (this.isSpace(read)) {
            return false;
        }
        return this.findFromValidStartSequence(scanner, read);
    }

    private boolean findFromValidStartSequence(PlainJavaCharacterScanner scanner, int read) {
        int index = 0;
        int lastCharBeforeEnding = 32;
        EndlessLoopPreventer endlessLoopPreventer = new EndlessLoopPreventer(10000);
        while (true) {
            endlessLoopPreventer.assertNoEndlessLoop();
            if (this.isTerminatingLine(read)) {
                return false;
            }
            char current = (char)read;
            if (this.ending[index] == current) {
                if (++index == this.ending.length) {
                    return this.isValidEndsequence(scanner, lastCharBeforeEnding);
                }
            } else {
                lastCharBeforeEnding = read;
                index = 0;
            }
            read = scanner.read();
        }
    }

    private boolean isValidEndsequence(PlainJavaCharacterScanner scanner, int lastCharBeforeEnding) {
        if (this.isSpace(lastCharBeforeEnding)) {
            return false;
        }
        int read = scanner.read();
        if (this.isEOF(read)) {
            return true;
        }
        if (this.isTerminatingLine(read) || !Character.isAlphabetic(read)) {
            scanner.unread();
            return true;
        }
        return false;
    }

    private boolean isTerminatingLine(int read) {
        return this.isEOF(read) || this.isEOL(read);
    }

    private boolean isEOL(int read) {
        return read == 10 || read == 13;
    }

    private boolean isEOF(int read) {
        return read == -1;
    }

    private boolean isSpace(int read) {
        return read == 32 || read == 255;
    }

    private boolean isLineBreak(int read, PlainJavaCharacterScanner adapter) {
        return read == 13 || read == 10;
    }
}

