/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.document;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class AsciiDoctorVariableRule
implements IPredicateRule {
    private IToken token;

    public AsciiDoctorVariableRule(IToken token) {
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        char start = (char)scanner.read();
        if (!this.isWordStart(start)) {
            scanner.unread();
            return Token.UNDEFINED;
        }
        ScanContext context = new ScanContext();
        context.state = State.INITIAL;
        while (true) {
            int read = scanner.read();
            char c = (char)read;
            if (-1 == read || !this.isWordPart(c, context)) {
                scanner.unread();
                break;
            }
            if (context.hasEndReached()) break;
            if (context.state != State.INITIAL) continue;
            context.state = State.NORMAL;
        }
        return this.getSuccessToken();
    }

    private boolean isWordStart(char c) {
        return c == '$';
    }

    private boolean isWordPart(char c, ScanContext context) {
        if (c == '\n') {
            return false;
        }
        if (c == '{') {
            if (context.state == State.NORMAL) {
                return false;
            }
            if (context.state == State.INITIAL) {
                context.state = State.CURLY_OPENED;
            }
            ++context.curlyBracesOpened;
            return true;
        }
        if (c == '}') {
            ++context.curlyBracesClosed;
        }
        if (c == '(') {
            if (context.state == State.NORMAL) {
                return false;
            }
            if (context.state == State.INITIAL) {
                context.state = State.GROUP_OPENED;
            }
            ++context.groupOpened;
            return true;
        }
        if (c == ')') {
            ++context.groupClosed;
        }
        if (context.state == State.GROUP_OPENED) {
            return true;
        }
        if (context.state == State.CURLY_OPENED) {
            return true;
        }
        if (Character.isWhitespace(c)) {
            return false;
        }
        if (c == '\'' || c == '\"' || c == '`') {
            return false;
        }
        return context.state != State.NORMAL || c != '/';
    }

    private class ScanContext {
        State state;
        int curlyBracesOpened = 0;
        int groupOpened = 0;
        int curlyBracesClosed;
        int groupClosed;

        private ScanContext() {
        }

        public boolean hasEndReached() {
            if (this.state == State.CURLY_OPENED) {
                return this.curlyBracesClosed == this.curlyBracesOpened;
            }
            if (this.state == State.GROUP_OPENED) {
                return this.groupClosed == this.groupOpened;
            }
            return false;
        }
    }

    private static enum State {
        INITIAL,
        NORMAL,
        CURLY_OPENED,
        GROUP_OPENED;

    }
}

