/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.document;

import de.jcup.asciidoctoreditor.document.AsciiDoctorDocumentIdentifier;
import de.jcup.asciidoctoreditor.document.AsciiDoctorPlantUMLDocumentIdentifiers;
import de.jcup.asciidoctoreditor.document.ExactWordPatternRule;
import de.jcup.asciidoctoreditor.document.OnlyLettersKeyWordDetector;
import de.jcup.asciidoctoreditor.document.keywords.PlantUMLArrowKeywords;
import de.jcup.asciidoctoreditor.document.keywords.PlantUMLColorDocumentKeywords;
import de.jcup.asciidoctoreditor.document.keywords.PlantUMLKeywordDocumentKeywords;
import de.jcup.asciidoctoreditor.document.keywords.PlantUMLMissingKeywordDocumentKeywords;
import de.jcup.asciidoctoreditor.document.keywords.PlantUMLPreprocessorDocumentKeywords;
import de.jcup.asciidoctoreditor.document.keywords.PlantUMLSkinparameterDocumentKeywords;
import de.jcup.asciidoctoreditor.document.keywords.PlantUMLTypeDocumentKeywords;
import de.jcup.eclipse.commons.keyword.DocumentKeyWord;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class AsciiDoctorPlantUMLDocumentPartitionScanner
extends RuleBasedPartitionScanner {
    private OnlyLettersKeyWordDetector onlyLettersWordDetector = new OnlyLettersKeyWordDetector();

    public AsciiDoctorPlantUMLDocumentPartitionScanner() {
        IToken note = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_NOTE);
        IToken comment = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_COMMENT);
        IToken divider = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_DIVIDER);
        IToken color = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_COLOR);
        IToken skinparameter = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_SKINPARAMETER);
        IToken type = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_TYPE);
        IToken string = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_DOUBLE_STRING);
        IToken preprocessor = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_PREPROCESSOR);
        IToken keyword = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_KEYWORD);
        IToken arrow = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_ARROW);
        IToken label = this.createToken(AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_LABEL);
        ArrayList<IPredicateRule> rules = new ArrayList<IPredicateRule>();
        rules.add((IPredicateRule)new SingleLineRule("'", "", comment, '\uffff', true));
        rules.add((IPredicateRule)new MultiLineRule("/'", "'/", comment, '\uffff', true));
        rules.add((IPredicateRule)new SingleLineRule("\"", "\"", string, '\uffff', true));
        rules.add((IPredicateRule)new SingleLineRule("note", " ", note, '\uffff', true));
        rules.add((IPredicateRule)new SingleLineRule("end note", " ", note, '\uffff', true));
        rules.add((IPredicateRule)new SingleLineRule("===", "===", divider, '\uffff', true));
        rules.add((IPredicateRule)new SingleLineRule("==", "==", divider, '\uffff', true));
        rules.add((IPredicateRule)new SingleLineRule("@startuml", "", preprocessor, '\uffff', true));
        rules.add((IPredicateRule)new SingleLineRule("@enduml", "", preprocessor, '\uffff', true));
        rules.add((IPredicateRule)new SingleLineRule(":", "", label, '\uffff', true));
        this.buildWordRules(rules, color, PlantUMLColorDocumentKeywords.values());
        rules.add(new HashColorRule(color));
        this.buildWordRules(rules, keyword, PlantUMLKeywordDocumentKeywords.values());
        this.buildWordRules(rules, keyword, PlantUMLMissingKeywordDocumentKeywords.values());
        this.buildWordRules(rules, preprocessor, PlantUMLPreprocessorDocumentKeywords.values());
        this.buildWordRules(rules, skinparameter, PlantUMLSkinparameterDocumentKeywords.values());
        this.buildWordRules(rules, type, PlantUMLTypeDocumentKeywords.values());
        this.buildWordRules(rules, arrow, PlantUMLArrowKeywords.values());
        this.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
    }

    private void buildWordRules(List<IPredicateRule> rules, IToken token, DocumentKeyWord[] values) {
        DocumentKeyWord[] documentKeyWordArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentKeyWord keyWord = documentKeyWordArray[n2];
            rules.add((IPredicateRule)new ExactWordPatternRule(this.onlyLettersWordDetector, this.createWordStart(keyWord), token, keyWord.isBreakingOnEof()));
            ++n2;
        }
    }

    private String createWordStart(DocumentKeyWord keyWord) {
        return keyWord.getText();
    }

    private IToken createToken(AsciiDoctorDocumentIdentifier identifier) {
        return new Token((Object)identifier.getId());
    }

    private class HashColorRule
    implements IPredicateRule {
        private IToken successToken;

        public HashColorRule(IToken token) {
            this.successToken = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            return this.evaluate(scanner, true);
        }

        public IToken getSuccessToken() {
            return this.successToken;
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            char c;
            char first = (char)scanner.read();
            if ('#' != first) {
                scanner.unread();
                return Token.UNDEFINED;
            }
            int countOfScans = 1;
            do {
                c = (char)scanner.read();
                ++countOfScans;
                if (!Character.isWhitespace(c)) continue;
                return this.successToken;
            } while (Character.isDigit(c) || Character.isAlphabetic(c));
            int i = 0;
            while (i < countOfScans) {
                scanner.unread();
                ++i;
            }
            return Token.UNDEFINED;
        }
    }
}

