/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.document;

import de.jcup.asciidoctoreditor.EndlessLoopPreventer;
import de.jcup.asciidoctoreditor.document.AsciiDoctorDocumentPartitionScanner;
import de.jcup.asciidoctoreditor.document.Counter;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class AsciiDoctorLiteralParagraphRule
implements IPredicateRule {
    private IToken successToken;

    public AsciiDoctorLiteralParagraphRule(IToken token) {
        this.successToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        boolean checkLineBefore;
        int c;
        boolean startOfDocument;
        if (!(scanner instanceof AsciiDoctorDocumentPartitionScanner)) {
            return Token.UNDEFINED;
        }
        AsciiDoctorDocumentPartitionScanner partitionScanner = (AsciiDoctorDocumentPartitionScanner)scanner;
        Counter counter = new Counter();
        boolean newLine = startOfDocument = partitionScanner.getOffset() == 0;
        if (!startOfDocument) {
            scanner.unread();
            int cbefore = scanner.read();
            newLine = newLine || cbefore == 10;
            boolean bl = newLine = newLine || cbefore == 13;
        }
        if (!newLine) {
            return Token.UNDEFINED;
        }
        int firstChar = scanner.read();
        scanner.unread();
        if (firstChar != 32) {
            return Token.UNDEFINED;
        }
        counter = new Counter();
        boolean foundPotentialList = false;
        do {
            c = scanner.read();
            ++counter.count;
            if (!foundPotentialList) continue;
            if (c != 32) break;
            counter.cleanup(scanner);
            return Token.UNDEFINED;
        } while (c == 32 || (foundPotentialList = c == 42 || c == 46 || c == 45));
        String lineWithoutWhitespaces = null;
        boolean bl = checkLineBefore = partitionScanner.getOffset() > 0;
        if (checkLineBefore) {
            StringBuilder lineBeforeWithoutWhitespaces = null;
            EndlessLoopPreventer preventer = new EndlessLoopPreventer(100000);
            boolean firstNewLine = true;
            while (partitionScanner.getOffset() > 0) {
                scanner.unread();
                int c2 = scanner.read();
                if (c2 == -1) break;
                if (c2 == 10) {
                    if (!firstNewLine) break;
                    firstNewLine = false;
                    lineBeforeWithoutWhitespaces = new StringBuilder();
                } else if (lineBeforeWithoutWhitespaces != null && !Character.isWhitespace(c2)) {
                    lineBeforeWithoutWhitespaces.insert(0, (char)c2);
                }
                scanner.unread();
                --counter.count;
                preventer.assertNoEndlessLoop();
            }
            boolean accepted = false;
            lineWithoutWhitespaces = lineBeforeWithoutWhitespaces == null ? "" : lineBeforeWithoutWhitespaces.toString();
            accepted = accepted || lineWithoutWhitespaces.isEmpty();
            accepted = accepted || lineWithoutWhitespaces.startsWith("=");
            accepted = accepted || lineWithoutWhitespaces.startsWith(".");
            accepted = accepted || lineWithoutWhitespaces.startsWith("****");
            counter.cleanup(scanner);
            if (!accepted) {
                return Token.UNDEFINED;
            }
        } else {
            lineWithoutWhitespaces = "";
        }
        EndlessLoopPreventer preventer = new EndlessLoopPreventer(100000);
        StringBuilder lineBuilder = new StringBuilder();
        while (true) {
            if (lineWithoutWhitespaces.isEmpty() && lineBuilder.toString().trim().startsWith("1. ")) {
                counter.cleanup(scanner);
                return Token.UNDEFINED;
            }
            int follow = scanner.read();
            ++counter.count;
            if (follow == -1) {
                return this.successToken;
            }
            if (follow == 10 || follow == 13) {
                boolean fetchedLineBeforeIsEmpty;
                boolean bl2 = fetchedLineBeforeIsEmpty = lineBuilder.length() == 0;
                if (fetchedLineBeforeIsEmpty) {
                    return this.successToken;
                }
                lineBuilder = new StringBuilder();
            } else if (lineBuilder.length() > 0 || !Character.isWhitespace(follow)) {
                lineBuilder.append((char)follow);
            }
            preventer.assertNoEndlessLoop();
        }
    }
}

