/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.document;

import de.jcup.asciidoctoreditor.EndlessLoopPreventer;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class AsciiDoctorLineStartsWithRule
implements IPredicateRule {
    private IToken successToken;
    private char[] startsWith;
    private char[] endsWith;
    private boolean multiLines;
    private boolean mustHaveWhitespaceAfter;

    public AsciiDoctorLineStartsWithRule(String startsWith, IToken token) {
        this(startsWith, false, token);
    }

    public AsciiDoctorLineStartsWithRule(String startsWith, boolean multiLines, IToken token) {
        this(startsWith, null, multiLines, token, false);
    }

    public AsciiDoctorLineStartsWithRule(String startsWith, String endsWith, boolean multiLines, IToken token) {
        this(startsWith, endsWith, multiLines, token, false);
    }

    public AsciiDoctorLineStartsWithRule(String startsWith, String endsWith, boolean multiLines, IToken token, boolean mustHaveWhitespaceAfter) {
        this.successToken = token;
        this.multiLines = multiLines;
        this.startsWith = startsWith.toCharArray();
        this.endsWith = endsWith == null ? new char[]{} : endsWith.toCharArray();
        this.mustHaveWhitespaceAfter = mustHaveWhitespaceAfter;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    private boolean isTerminatedByWhitespaceOrEOF(ICharacterScanner scanner) {
        int n = scanner.read();
        if (n != -1) {
            scanner.unread();
        }
        char c = (char)n;
        boolean isOkay = n == -1 || Character.isWhitespace(c);
        return isOkay;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int count;
        block15: {
            boolean startOfDocument;
            boolean newLine = startOfDocument = scanner.getColumn() == 0;
            if (!startOfDocument) {
                scanner.unread();
                int cbefore = scanner.read();
                newLine = newLine || cbefore == 10;
                boolean bl = newLine = newLine || cbefore == 13;
            }
            if (!newLine) {
                return Token.UNDEFINED;
            }
            count = 0;
            int i = 0;
            while (i < this.startsWith.length) {
                int c = scanner.read();
                ++count;
                if (this.startsWith[i] != c) {
                    return this.resetScannerAndReturnUndefined(scanner, count);
                }
                ++i;
            }
            if (this.mustHaveWhitespaceAfter && !this.isTerminatedByWhitespaceOrEOF(scanner)) {
                return this.resetScannerAndReturnUndefined(scanner, count);
            }
            EndlessLoopPreventer preventer = new EndlessLoopPreventer(100000);
            boolean noEndsWithScanNecessary = this.endsWith.length == 0;
            int n = -1;
            int endsWithPos = 0;
            while (true) {
                preventer.assertNoEndlessLoop();
                int n2 = scanner.read();
                ++count;
                if (n2 == -1) {
                    if (noEndsWithScanNecessary) {
                        return this.getSuccessToken();
                    }
                    return this.resetScannerAndReturnUndefined(scanner, count);
                }
                if (n2 == 10) {
                    if (this.multiLines) {
                        endsWithPos = 0;
                        continue;
                    }
                    if (noEndsWithScanNecessary) {
                        return this.getSuccessToken();
                    }
                    return this.resetScannerAndReturnUndefined(scanner, count);
                }
                if (noEndsWithScanNecessary) continue;
                if (this.multiLines) {
                    if (endsWithPos >= this.endsWith.length) continue;
                    if (n2 != this.endsWith[endsWithPos]) {
                        endsWithPos = this.endsWith.length + 1;
                        continue;
                    }
                    if (++endsWithPos != this.endsWith.length) continue;
                    if (this.mustHaveWhitespaceAfter && !this.isTerminatedByWhitespaceOrEOF(scanner)) {
                        endsWithPos = this.endsWith.length + 1;
                        continue;
                    }
                    return this.getSuccessToken();
                }
                if (endsWithPos >= this.endsWith.length) break block15;
                if (n2 == this.endsWith[endsWithPos]) {
                    ++endsWithPos;
                }
                if (endsWithPos != this.endsWith.length) continue;
                if (!this.mustHaveWhitespaceAfter || this.isTerminatedByWhitespaceOrEOF(scanner)) break;
                endsWithPos = this.endsWith.length + 1;
            }
            return this.getSuccessToken();
        }
        return this.resetScannerAndReturnUndefined(scanner, count);
    }

    private IToken resetScannerAndReturnUndefined(ICharacterScanner scanner, int count) {
        while (count > 0) {
            scanner.unread();
            --count;
        }
        return Token.UNDEFINED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(":starsWith='");
        sb.append(this.startsWith);
        sb.append("', endsWith='");
        sb.append(this.endsWith);
        sb.append("', multiLines=");
        sb.append(this.multiLines);
        return sb.toString();
    }
}

