/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.document;

import de.jcup.asciidoctoreditor.EndlessLoopPreventer;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class AsciiDoctorLineContainsOnlyRule
implements IPredicateRule {
    private IToken successToken;
    private char[] contains;

    public AsciiDoctorLineContainsOnlyRule(String startsWith, IToken token) {
        this.contains = startsWith.toCharArray();
        this.successToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int c;
        boolean startOfDocument;
        boolean newLine = startOfDocument = scanner.getColumn() == 0;
        if (!startOfDocument) {
            scanner.unread();
            int cbefore = scanner.read();
            newLine = newLine || cbefore == 10;
            boolean bl = newLine = newLine || cbefore == 13;
        }
        if (!newLine) {
            return Token.UNDEFINED;
        }
        int count = 0;
        int i = 0;
        while (i < this.contains.length) {
            c = scanner.read();
            ++count;
            if (this.contains[i] != c) {
                return this.resetScannerAndReturnUndefined(scanner, count);
            }
            ++i;
        }
        EndlessLoopPreventer preventer = new EndlessLoopPreventer(100000);
        c = -1;
        preventer.assertNoEndlessLoop();
        c = scanner.read();
        ++count;
        if (c == -1) {
            return this.getSuccessToken();
        }
        if (c == 10) {
            return this.getSuccessToken();
        }
        return this.resetScannerAndReturnUndefined(scanner, count);
    }

    private IToken resetScannerAndReturnUndefined(ICharacterScanner scanner, int count) {
        while (count > 0) {
            scanner.unread();
            --count;
        }
        return Token.UNDEFINED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(":contains='");
        sb.append(this.contains);
        return sb.toString();
    }
}

