/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.document;

import de.jcup.asciidoctoreditor.document.AsciiDoctorDocumentIdentifier;
import de.jcup.asciidoctoreditor.document.AsciiDoctorDocumentIdentifiers;
import de.jcup.asciidoctoreditor.document.AsciiDoctorFormattedTextRule;
import de.jcup.asciidoctoreditor.document.AsciiDoctorLineContainsOnlyRule;
import de.jcup.asciidoctoreditor.document.AsciiDoctorLineStartsWithRule;
import de.jcup.asciidoctoreditor.document.AsciiDoctorLiteralParagraphRule;
import de.jcup.asciidoctoreditor.document.AsciiDoctorURLHyperlinkRule;
import de.jcup.asciidoctoreditor.document.AsciiDoctorVariableRule;
import de.jcup.asciidoctoreditor.document.keywords.AsciiDoctorAdmonitionParagraphKeyWords;
import de.jcup.asciidoctoreditor.document.keywords.AsciiDoctorCommandKeyWords;
import de.jcup.asciidoctoreditor.document.keywords.AsciiDoctorIncludeKeywords;
import de.jcup.eclipse.commons.keyword.DocumentKeyWord;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class AsciiDoctorDocumentPartitionScanner
extends RuleBasedPartitionScanner {
    public AsciiDoctorDocumentPartitionScanner() {
        IToken boldText = this.createToken(AsciiDoctorDocumentIdentifiers.TEXT_BOLD);
        IToken italicText = this.createToken(AsciiDoctorDocumentIdentifiers.TEXT_ITALIC);
        IToken monospacedText = this.createToken(AsciiDoctorDocumentIdentifiers.TEXT_MONOSPACED);
        IToken hyperlink = this.createToken(AsciiDoctorDocumentIdentifiers.HYPERLINK);
        IToken comment = this.createToken(AsciiDoctorDocumentIdentifiers.COMMENT);
        IToken textBlock = this.createToken(AsciiDoctorDocumentIdentifiers.TEXT_BLOCK);
        IToken knownVariables = this.createToken(AsciiDoctorDocumentIdentifiers.KNOWN_VARIABLES);
        IToken variables = this.createToken(AsciiDoctorDocumentIdentifiers.VARIABLES);
        IToken includeKeyword = this.createToken(AsciiDoctorDocumentIdentifiers.INCLUDE_KEYWORD);
        IToken asciidoctorCommand = this.createToken(AsciiDoctorDocumentIdentifiers.ASCIIDOCTOR_COMMAND);
        IToken headline = this.createToken(AsciiDoctorDocumentIdentifiers.HEADLINE);
        IToken delimiters = this.createToken(AsciiDoctorDocumentIdentifiers.DELIMITERS);
        ArrayList<IPredicateRule> rules = new ArrayList<IPredicateRule>();
        rules.add(new AsciiDoctorVariableRule(variables));
        rules.add(new AsciiDoctorURLHyperlinkRule(hyperlink));
        this.aLineStartsWith("= ", rules, headline);
        this.aLineStartsWith("== ", rules, headline);
        this.aLineStartsWith("=== ", rules, headline);
        this.aLineStartsWith("==== ", rules, headline);
        this.aLineStartsWith("===== ", rules, headline);
        this.aLineStartsWith("====== ", rules, headline);
        this.aLineStartsWith("|===", rules, asciidoctorCommand);
        AsciiDoctorAdmonitionParagraphKeyWords[] asciiDoctorAdmonitionParagraphKeyWordsArray = AsciiDoctorAdmonitionParagraphKeyWords.values();
        int n = asciiDoctorAdmonitionParagraphKeyWordsArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsciiDoctorAdmonitionParagraphKeyWords admonitionKeyword = asciiDoctorAdmonitionParagraphKeyWordsArray[n2];
            this.aLineStartsWith(admonitionKeyword.getText(), rules, asciidoctorCommand, true);
            ++n2;
        }
        rules.add(new AsciiDoctorLineStartsWithRule("[[", "]]", false, asciidoctorCommand));
        rules.add(new AsciiDoctorLineStartsWithRule("[", "]", false, asciidoctorCommand));
        rules.add(new AsciiDoctorLineStartsWithRule("////", "////", true, comment));
        rules.add(new AsciiDoctorLineStartsWithRule("//", null, false, comment));
        rules.add(new AsciiDoctorLineStartsWithRule("----", "----", true, textBlock, true));
        rules.add(new AsciiDoctorFormattedTextRule("`", "`", monospacedText));
        rules.add(new AsciiDoctorFormattedTextRule("**", "**", boldText));
        rules.add(new AsciiDoctorFormattedTextRule("*", "*", boldText));
        rules.add(new AsciiDoctorFormattedTextRule("_", "_", italicText));
        rules.add((IPredicateRule)new SingleLineRule("<<", ">>", hyperlink, '\uffff', true));
        this.buildLineStartsWithRule(rules, asciidoctorCommand, "]", AsciiDoctorCommandKeyWords.values());
        this.buildLineStartsWithRule(rules, includeKeyword, "]", AsciiDoctorIncludeKeywords.values());
        rules.add(new AsciiDoctorLineStartsWithRule(":", ":", false, knownVariables));
        rules.add((IPredicateRule)new SingleLineRule("{", "}", knownVariables, '\uffff', true));
        rules.add(new AsciiDoctorLineContainsOnlyRule("....", delimiters));
        rules.add(new AsciiDoctorLineContainsOnlyRule("====", delimiters));
        rules.add(new AsciiDoctorLineContainsOnlyRule("****", delimiters));
        rules.add(new AsciiDoctorLineStartsWithRule(".", headline));
        rules.add(new AsciiDoctorLiteralParagraphRule(delimiters));
        this.setPredicateRules(rules.toArray(new IPredicateRule[rules.size()]));
    }

    private void buildLineStartsWithRule(List<IPredicateRule> rules, IToken token, String ending, DocumentKeyWord[] values) {
        DocumentKeyWord[] documentKeyWordArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentKeyWord keyWord = documentKeyWordArray[n2];
            String text = keyWord.getText();
            rules.add(new AsciiDoctorLineStartsWithRule(text, ending, false, token));
            ++n2;
        }
    }

    private void aLineStartsWith(String startsWith, List<IPredicateRule> rules, IToken token) {
        this.aLineStartsWith(startsWith, rules, token, false);
    }

    private void aLineStartsWith(String startsWith, List<IPredicateRule> rules, IToken token, boolean endOnSpace) {
        String endsWith = null;
        if (endOnSpace) {
            endsWith = " ";
        }
        rules.add(new AsciiDoctorLineStartsWithRule(startsWith, endsWith, false, token));
    }

    public int getOffset() {
        return this.fOffset;
    }

    private IToken createToken(AsciiDoctorDocumentIdentifier identifier) {
        return new Token((Object)identifier.getId());
    }
}

