/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.diagram.plantuml;

import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLInclude;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLModel;

public class SimplePlantUMLParser {
    private static final String INCLUDE = "!include ";
    private static final int INCLUDE_LENGTH = "!include ".length();
    private static final String INCLUDE_URL = "!includeurl ";
    private static final int INCLUDE_URL_LENGTH = "!includeurl ".length();

    public PlantUMLModel parse(String text) {
        PlantUMLModel model = new PlantUMLModel();
        String[] lines = text.split("\n");
        int lineNr = 1;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.inspectLine(line, lineNr++, model);
            ++n2;
        }
        return model;
    }

    private void inspectLine(String line, int lineNr, PlantUMLModel model) {
        if (line.startsWith(INCLUDE)) {
            String includePart = line.substring(INCLUDE_LENGTH).trim();
            this.addInclude(model, includePart, lineNr);
        } else if (line.startsWith(INCLUDE_URL)) {
            String includePart = line.substring(INCLUDE_URL_LENGTH).trim();
            this.addInclude(model, includePart, lineNr);
        }
    }

    private void addInclude(PlantUMLModel model, String includePart, int lineNr) {
        PlantUMLInclude include = new PlantUMLInclude(includePart);
        include.setLineNumber(lineNr);
        model.getIncludes().add(include);
    }
}

