/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.diagram.plantuml;

import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLInclude;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLModel;
import de.jcup.asciidoctoreditor.diagram.plantuml.SimplePlantUMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class PlantUMLLocalIncludeHierarchySearch {
    private SimplePlantUMLParser parser = new SimplePlantUMLParser();
    private File baseFolder = new File(".");

    public List<File> searchLocalIncludes(String text) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.searchLocalIncludes(files, text, 0);
        return files;
    }

    private void searchLocalIncludes(List<File> files, String text, int level) throws IOException {
        if (level > 100) {
            throw new IOException("Maximium recursive include scan level reached:" + level);
        }
        PlantUMLModel model = this.parser.parse(text);
        List<PlantUMLInclude> includes = model.getIncludes();
        for (PlantUMLInclude include : includes) {
            if (!include.isLocal()) continue;
            String location = include.getLocation();
            File file = new File(this.baseFolder, location);
            if (!file.exists()) {
                throw new FileNotFoundException("Include not found:" + file.getAbsolutePath());
            }
            files.add(file);
            Throwable throwable = null;
            Object var11_12 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                String loadedText = IOUtils.toString((InputStream)fis, (String)"UTF-8");
                this.searchLocalIncludes(files, loadedText, level + 1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void setBaseFolder(File baseFolder) {
        this.baseFolder = baseFolder;
    }
}

