/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.diagram.plantuml;

import de.jcup.asciidoctoreditor.AbstractContentTransformer;
import de.jcup.asciidoctoreditor.ContentTransformerData;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLDataProvider;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLOutputFormat;

public class PlantUMLContentTransformer
extends AbstractContentTransformer {
    private PlantUMLDataProvider provider;

    public void setDataProvider(PlantUMLDataProvider provider) {
        this.provider = provider;
    }

    @Override
    protected String saveTransform(ContentTransformerData data) {
        StringBuilder sb = new StringBuilder();
        if (data.origin != null) {
            PlantUMLOutputFormat format;
            sb.append("[plantuml");
            if (data.filename != null && !data.filename.isEmpty()) {
                sb.append(",");
                sb.append(data.filename);
            }
            if (this.provider != null && (format = this.provider.getOutputFormat()) != null) {
                sb.append(",");
                sb.append(format.getAsciiDocFormatString());
            }
            sb.append("]\n----\n");
            sb.append(data.origin);
            sb.append("\n----\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isTransforming(Object data) {
        return true;
    }
}

