/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.diagram.plantuml;

import de.jcup.asciidoctoreditor.AsciiDoctorTextHover;
import de.jcup.asciidoctoreditor.codeassist.PlantumlContentAssistProcessor;
import de.jcup.asciidoctoreditor.document.AsciiDoctorPlantUMLDocumentIdentifiers;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants;
import de.jcup.asciidoctoreditor.presentation.AsciiDoctorDefaultTextScanner;
import de.jcup.asciidoctoreditor.presentation.PresentationSupport;
import de.jcup.asciidoctoreditor.ui.ColorManager;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class AsciiDoctorPlantUMLSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private AsciiDoctorDefaultTextScanner scanner;
    private ColorManager colorManager;
    private TextAttribute defaultTextAttribute;
    private AsciiDoctorPlantUMLEditorAnnotationHoover annotationHoover;
    private ContentAssistant contentAssistant;
    private PlantumlContentAssistProcessor contentAssistProcessor;

    public AsciiDoctorPlantUMLSourceViewerConfiguration(IAdaptable adaptable) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        this.fPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{AsciiDoctorEditorUtil.getPreferences().getPreferenceStore(), generalTextStore});
        Assert.isNotNull((Object)adaptable, (String)"adaptable may not be null!");
        this.annotationHoover = new AsciiDoctorPlantUMLEditorAnnotationHoover();
        this.contentAssistant = new ContentAssistant();
        this.contentAssistProcessor = new PlantumlContentAssistProcessor();
        this.contentAssistant.enableColoredLabels(true);
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.contentAssistProcessor, "__dftl_partition_content_type");
        AsciiDoctorPlantUMLDocumentIdentifiers[] asciiDoctorPlantUMLDocumentIdentifiersArray = AsciiDoctorPlantUMLDocumentIdentifiers.values();
        int n = asciiDoctorPlantUMLDocumentIdentifiersArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsciiDoctorPlantUMLDocumentIdentifiers identifier = asciiDoctorPlantUMLDocumentIdentifiersArray[n2];
            this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.contentAssistProcessor, identifier.getId());
            ++n2;
        }
        this.contentAssistant.addCompletionListener(this.contentAssistProcessor.getCompletionListener());
        this.colorManager = (ColorManager)adaptable.getAdapter(ColorManager.class);
        Assert.isNotNull((Object)this.colorManager, (String)" adaptable must support color manager");
        this.defaultTextAttribute = new TextAttribute(this.colorManager.getColor(AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_NORMAL_TEXT)));
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        return this.contentAssistant;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        return null;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return this.annotationHoover;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new AsciiDoctorTextHover();
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return AsciiDoctorPlantUMLDocumentIdentifiers.allIdsToStringArray("__dftl_partition_content_type");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        this.addDefaultPresentation(reconciler);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_PREPROCESSOR.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_PREPROCESSOR), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_DOUBLE_STRING.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_DOUBLESTRING), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_KEYWORD.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_KEYWORD), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_NOTE.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_NOTE), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_COMMENT.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_COMMENT), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_SKINPARAMETER.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_SKINPARAMETER), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_COLOR.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_COLOR), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_TYPE.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_TYPE), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_DIVIDER.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_DIVIDER), 0);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_ARROW.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_ARROW), 1);
        this.addPresentation(reconciler, AsciiDoctorPlantUMLDocumentIdentifiers.PLANTUML_LABEL.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_LABEL), 0);
        return reconciler;
    }

    private void addDefaultPresentation(PresentationReconciler reconciler) {
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
    }

    private IToken createColorToken(RGB rgb) {
        Token token = new Token((Object)new TextAttribute(this.colorManager.getColor(rgb)));
        return token;
    }

    private void addPresentation(PresentationReconciler reconciler, String id, RGB rgb, int style) {
        this.addPresentation(reconciler, id, rgb, style, null, null);
    }

    private void addPresentation(PresentationReconciler reconciler, String id, RGB foreGround, int style, Font font, RGB backGround) {
        Color backGroundColor = backGround == null ? this.defaultTextAttribute.getBackground() : this.colorManager.getColor(backGround);
        Color foreGroundColor = foreGround == null ? this.defaultTextAttribute.getForeground() : this.colorManager.getColor(foreGround);
        TextAttribute textAttribute = new TextAttribute(foreGroundColor, backGroundColor, style, font);
        PresentationSupport presentation = new PresentationSupport(textAttribute);
        reconciler.setDamager((IPresentationDamager)presentation, id);
        reconciler.setRepairer((IPresentationRepairer)presentation, id);
    }

    private AsciiDoctorDefaultTextScanner getDefaultTextScanner() {
        if (this.scanner == null) {
            this.scanner = new AsciiDoctorDefaultTextScanner(this.colorManager);
            this.updateTextScannerDefaultColorToken();
        }
        return this.scanner;
    }

    public void updateTextScannerDefaultColorToken() {
        if (this.scanner == null) {
            return;
        }
        RGB color = AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorPlantUMLEditorSyntaxColorPreferenceConstants.COLOR_PLANTUML_NORMAL_TEXT);
        this.scanner.setDefaultReturnToken(this.createColorToken(color));
    }

    private class AsciiDoctorPlantUMLEditorAnnotationHoover
    extends DefaultAnnotationHover {
        private AsciiDoctorPlantUMLEditorAnnotationHoover() {
        }

        protected boolean isIncluded(Annotation annotation) {
            return annotation instanceof MarkerAnnotation;
        }
    }
}

