/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.diagram.plantuml;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.ContentTransformer;
import de.jcup.asciidoctoreditor.CopySupport;
import de.jcup.asciidoctoreditor.EclipseDevelopmentSettings;
import de.jcup.asciidoctoreditor.EditorType;
import de.jcup.asciidoctoreditor.asciidoc.WrapperConvertData;
import de.jcup.asciidoctoreditor.diagram.plantuml.AsciiDoctorPlantUMLSourceViewerConfiguration;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLContentTransformer;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLDataProvider;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLLocalIncludeHierarchySearch;
import de.jcup.asciidoctoreditor.diagram.plantuml.PlantUMLOutputFormat;
import de.jcup.asciidoctoreditor.document.AsciiDoctorPlantUMLFileDocumentProvider;
import de.jcup.asciidoctoreditor.document.AsciiDoctorPlantUMLTextFileDocumentProvider;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.script.AsciiDoctorMarker;
import de.jcup.asciidoctoreditor.toolbar.AddErrorDebugAction;
import de.jcup.asciidoctoreditor.toolbar.ChangeLayoutAction;
import de.jcup.asciidoctoreditor.toolbar.JumpToTopOfAsciiDocViewAction;
import de.jcup.asciidoctoreditor.toolbar.OpenInExternalBrowserAction;
import de.jcup.asciidoctoreditor.toolbar.RebuildAsciiDocViewAction;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AsciiDoctorPlantUMLEditor
extends AsciiDoctorEditor
implements PlantUMLDataProvider {
    private static final AsciiDoctorPlantUMLFileDocumentProvider ASCII_DOCTOR_PLANT_UML_FILE_DOCUMENT_PROVIDER = new AsciiDoctorPlantUMLFileDocumentProvider();
    private static final AsciiDoctorPlantUMLTextFileDocumentProvider ASCII_DOCTOR_PLANT_UML_TEXT_FILE_DOCUMENT_PROVIDER = new AsciiDoctorPlantUMLTextFileDocumentProvider();
    private PlantUMLLocalIncludeHierarchySearch search = new PlantUMLLocalIncludeHierarchySearch();

    @Override
    public void beforeAsciidocConvert(WrapperConvertData data) {
        String text = this.getDocumentText();
        File file = data.editorFileOrNull;
        if (file == null) {
            return;
        }
        File parentFile = file.getParentFile();
        this.search.setBaseFolder(parentFile);
        List<File> files = null;
        try {
            files = this.search.searchLocalIncludes(text);
        }
        catch (IOException e) {
            this.warn("Include search problem: " + e.getMessage());
            return;
        }
        CopySupport copySupport = new CopySupport(parentFile, this.getTemporaryExternalPreviewFile().getParentFile());
        try {
            copySupport.copyFilesToNewBase(files);
        }
        catch (IOException e) {
            this.warn("Failed to copy local includes to temp folder: " + e.getMessage());
        }
    }

    private void warn(String message) {
        AsciiDoctorMarker error = new AsciiDoctorMarker(-1, -1, message);
        int severity = 1;
        AsciiDoctorEditorUtil.addAsciiDoctorMarker((IEditorPart)this, 1, error, severity);
    }

    @Override
    protected ContentTransformer createCustomContentTransformer() {
        PlantUMLContentTransformer transformer = new PlantUMLContentTransformer();
        transformer.setDataProvider(this);
        return transformer;
    }

    @Override
    protected String getTitleImageName(int severity) {
        return "plantuml-asciidoctor-editor.png";
    }

    @Override
    public EditorType getType() {
        return EditorType.PLANTUML;
    }

    @Override
    protected void initToolbar() {
        this.rebuildAction = new RebuildAsciiDocViewAction(this);
        ToolBarManager viewToolBarManager = new ToolBarManager(this.coolBarManager.getStyle());
        viewToolBarManager.add((IAction)new ChangeLayoutAction(this));
        viewToolBarManager.add((IAction)new RebuildAsciiDocViewAction(this));
        viewToolBarManager.add((IAction)new JumpToTopOfAsciiDocViewAction(this));
        ToolBarManager otherToolBarManager = new ToolBarManager(this.coolBarManager.getStyle());
        otherToolBarManager.add((IAction)new OpenInExternalBrowserAction(this));
        this.coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)viewToolBarManager, "asciiDocPlantUMLEditor.toolbar.view"));
        this.coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)otherToolBarManager, "asciiDocPlantUMLEditor.toolbar.other"));
        if (EclipseDevelopmentSettings.DEBUG_TOOLBAR_ENABLED) {
            ToolBarManager debugToolBar = new ToolBarManager(this.coolBarManager.getStyle());
            debugToolBar.add((IAction)new AddErrorDebugAction(this));
            this.coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)debugToolBar, "asciiDocEditor.toolbar.debug"));
        }
        this.coolBarManager.update(true);
    }

    @Override
    protected String getToggleCommentCodePart() {
        return "'";
    }

    @Override
    protected SourceViewerConfiguration createSourceViewerConfig() {
        return new AsciiDoctorPlantUMLSourceViewerConfiguration((IAdaptable)this);
    }

    @Override
    protected IDocumentProvider resolveDocumentProvider(IEditorInput input) {
        if (input instanceof FileStoreEditorInput) {
            return ASCII_DOCTOR_PLANT_UML_TEXT_FILE_DOCUMENT_PROVIDER;
        }
        return ASCII_DOCTOR_PLANT_UML_FILE_DOCUMENT_PROVIDER;
    }

    @Override
    public PlantUMLOutputFormat getOutputFormat() {
        return AsciiDoctorEditorPreferences.getInstance().getPlantUMLOutputFormat();
    }
}

