/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.console;

import de.jcup.asciidoctoreditor.console.AsciiDoctorConsole;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsoleStream;

public class AsciiDoctorConsoleUtil {
    public static void error(String message) {
        AsciiDoctorConsoleUtil.output(message);
        AsciiDoctorConsoleUtil.showConsoleOnErrorIfEnabled();
    }

    private static void showConsoleOnErrorIfEnabled() {
        if (AsciiDoctorEditorPreferences.getInstance().isConsoleAlwaysShownOnError()) {
            AsciiDoctorConsoleUtil.showConsole();
        }
    }

    public static void output(String message) {
        AsciiDoctorConsole myConsole = AsciiDoctorConsoleUtil.findConsole();
        MessageConsoleStream out = myConsole.newMessageStream();
        out.println(message);
    }

    public static void showConsole() {
        AsciiDoctorConsoleUtil.getConsoleManager().showConsoleView((IConsole)AsciiDoctorConsoleUtil.findConsole());
    }

    private static AsciiDoctorConsole findConsole() {
        IConsoleManager conMan = AsciiDoctorConsoleUtil.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (existing[i] instanceof AsciiDoctorConsole) {
                return (AsciiDoctorConsole)existing[i];
            }
            ++i;
        }
        AsciiDoctorConsole asciiDoctorConsole = new AsciiDoctorConsole(EclipseUtil.createImageDescriptor("icons/asciidoctor-editor.png", "de.jcup.asciidoctoreditor"));
        conMan.addConsoles(new IConsole[]{asciiDoctorConsole});
        return asciiDoctorConsole;
    }

    private static IConsoleManager getConsoleManager() {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        return conMan;
    }
}

